/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import groovy.util.Node;
import groovy.xml.QName;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.github.ngbinh.scalastyle.ScalaStylePlugin;
import org.github.ngbinh.scalastyle.ScalaStyleTask;
import org.gradle.api.Project;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public final class BaselineScalastyle
extends AbstractBaselinePlugin {
    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().withPlugin("scala", plugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            project.getTasks().withType(ScalaCompile.class).configureEach(scalaCompile -> scalaCompile.getScalaCompileOptions().setAdditionalParameters((List)ImmutableList.of((Object)("-target:jvm-" + javaConvention.getTargetCompatibility().toString()))));
            project.getRootProject().getPluginManager().withPlugin("idea", ideaPlugin -> project.getRootProject().getExtensions().configure(IdeaModel.class, ideaModel -> this.configureIdeaPlugin((IdeaModel)ideaModel, (SourceSet)javaConvention.getSourceSets().named("main").get(), javaConvention.getTargetCompatibility().toString())));
            project.getPluginManager().apply(ScalaStylePlugin.class);
            TaskCollection scalaStyleTasks = project.getTasks().withType(ScalaStyleTask.class);
            scalaStyleTasks.configureEach(scalaStyleTask -> {
                scalaStyleTask.setConfigLocation(project.getRootDir().toPath().resolve(Paths.get("project", "scalastyle_config.xml")).toString());
                scalaStyleTask.setIncludeTestSourceDirectory(Boolean.valueOf(true));
                scalaStyleTask.setFailOnWarning(Boolean.valueOf(true));
                javaConvention.getSourceSets().forEach(sourceSet -> sourceSet.getAllSource().getSrcDirs().forEach(resourceDir -> scalaStyleTask.source(new Object[]{resourceDir.toString()})));
            });
            project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{scalaStyleTasks}));
        });
    }

    private void configureIdeaPlugin(IdeaModel ideaModel, SourceSet mainSourceSet, String javaVersion) {
        Convention scalaConvention = (Convention)InvokerHelper.getProperty((Object)mainSourceSet, (String)"convention");
        ScalaSourceSet scalaSourceSet = (ScalaSourceSet)scalaConvention.getPlugin(ScalaSourceSet.class);
        String compilerMode = scalaSourceSet.getScala().filter(file -> file.getName().endsWith("java")).isEmpty() ? "JavaThenScala" : "Mixed";
        ideaModel.getProject().getIpr().withXml(xmlProvider -> {
            String targetJvmVersion = "-target:jvm-" + javaVersion;
            Node rootNode = xmlProvider.asNode();
            Node scalaCompilerConf = (Node)rootNode.getAt(new QName("component")).stream().filter(o -> ((Node)o).attributes().get("name").equals("ScalaCompilerConfiguration")).findFirst().orElseGet(() -> rootNode.appendNode((Object)"component", (Map)ImmutableMap.of((Object)"name", (Object)"ScalaCompilerConfiguration")));
            Node compilerOrder = (Node)scalaCompilerConf.getAt(new QName("option")).stream().filter(o -> ((Node)o).attributes().get("name").equals("compileOrder")).findFirst().orElseGet(() -> scalaCompilerConf.appendNode((Object)"option"));
            compilerOrder.attributes().put("name", "compileOrder");
            compilerOrder.attributes().put("value", compilerMode);
            Node parametersNode = (Node)scalaCompilerConf.getAt(new QName("parameters")).stream().findFirst().orElseGet(() -> scalaCompilerConf.appendNode((Object)"parameters"));
            Node parameter = (Node)parametersNode.getAt(new QName("parameter")).stream().filter(o -> ((Node)o).attributes().get("value").equals(targetJvmVersion)).findFirst().orElseGet(() -> parametersNode.appendNode((Object)"parameter"));
            parameter.attributes().put("value", targetJvmVersion);
        });
    }
}

