/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableList;
import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import java.util.Collections;
import java.util.Optional;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaselineReleaseCompatibility
extends AbstractBaselinePlugin {
    private static final Logger log = LoggerFactory.getLogger(BaselineReleaseCompatibility.class);

    public void apply(Project project) {
        this.project = project;
        project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> javaCompile.getOptions().getCompilerArgumentProviders().add(new ReleaseFlagProvider((JavaCompile)javaCompile)));
    }

    private static final class ReleaseFlagProvider
    implements CommandLineArgumentProvider {
        private final JavaCompile javaCompile;

        private ReleaseFlagProvider(JavaCompile javaCompile) {
            this.javaCompile = javaCompile;
        }

        public Iterable<String> asArguments() {
            JavaVersion jdkVersion = JavaVersion.toVersion((Object)this.javaCompile.getToolChain().getVersion());
            if (!ReleaseFlagProvider.supportsReleaseFlag(jdkVersion)) {
                log.debug("BaselineReleaseCompatibility is a no-op for {} in {} as {} doesn't support --release", new Object[]{this.javaCompile.getName(), this.javaCompile.getProject(), jdkVersion});
                return Collections.emptyList();
            }
            Optional<JavaVersion> taskTarget = Optional.ofNullable(this.javaCompile.getTargetCompatibility()).map(JavaVersion::toVersion);
            if (!taskTarget.isPresent()) {
                log.debug("BaselineReleaseCompatibility is a no-op for {} in {} as no targetCompatibility is set", (Object)this.javaCompile.getName(), (Object)this.javaCompile.getProject());
                return Collections.emptyList();
            }
            JavaVersion target = taskTarget.get();
            if (jdkVersion.compareTo((Enum)target) <= 0) {
                log.debug("BaselineReleaseCompatibility is a no-op for {} in {} as targetCompatibility is higher", (Object)this.javaCompile.getName(), (Object)this.javaCompile.getProject());
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)"--release", (Object)target.getMajorVersion());
        }

        private static boolean supportsReleaseFlag(JavaVersion jdkVersion) {
            return jdkVersion.isJava9Compatible();
        }
    }
}

