/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.palantir.baseline.tasks.CheckImplicitDependenciesParentTask;
import com.palantir.baseline.tasks.CheckImplicitDependenciesTask;
import com.palantir.baseline.tasks.CheckUnusedDependenciesParentTask;
import com.palantir.baseline.tasks.CheckUnusedDependenciesTask;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DefaultClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.asm.ASMDependencyAnalyzer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;

public final class BaselineExactDependencies
implements Plugin<Project> {
    private static final ClassAnalyzer JAR_ANALYZER = new DefaultClassAnalyzer();
    private static final DependencyAnalyzer CLASS_FILE_ANALYZER = new ASMDependencyAnalyzer();
    public static final Indexes INDEXES = new Indexes();
    public static final ImmutableSet<String> VALID_ARTIFACT_EXTENSIONS = ImmutableSet.of((Object)"jar", (Object)"");

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            TaskProvider checkUnusedDependencies = project.getTasks().register("checkUnusedDependencies", CheckUnusedDependenciesParentTask.class);
            TaskProvider checkImplicitDependencies = project.getTasks().register("checkImplicitDependencies", CheckImplicitDependenciesParentTask.class);
            ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> BaselineExactDependencies.configureSourceSet(project, sourceSet, (TaskProvider<CheckUnusedDependenciesParentTask>)checkUnusedDependencies, (TaskProvider<CheckImplicitDependenciesParentTask>)checkImplicitDependencies));
        });
    }

    private static void configureSourceSet(Project project, SourceSet sourceSet, TaskProvider<CheckUnusedDependenciesParentTask> checkUnusedDependencies, TaskProvider<CheckImplicitDependenciesParentTask> checkImplicitDependencies) {
        Configuration implementation = project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
        Configuration compile = project.getConfigurations().getByName(sourceSet.getCompileConfigurationName());
        Configuration compileClasspath = project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName());
        Configuration explicitCompile = (Configuration)project.getConfigurations().create("baseline-exact-dependencies-" + sourceSet.getName(), conf -> {
            conf.setDescription(String.format("Tracks the explicit (not inherited) dependencies added to either %s or %s", compile.toString(), implementation.toString()));
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-api")));
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.6")) >= 0) {
                    attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "classes")));
                }
            });
            compileClasspath.getAttributes().keySet().forEach(attribute -> {
                Object value = compileClasspath.getAttributes().getAttribute(attribute);
                conf.getAttributes().attribute(attribute, value);
            });
        });
        project.afterEvaluate(p -> {
            Configuration implCopy = implementation.copy();
            Configuration compileCopy = compile.copy();
            compileCopy.setCanBeResolved(false);
            compileCopy.setCanBeConsumed(false);
            project.getConfigurations().add((Object)implCopy);
            project.getConfigurations().add((Object)compileCopy);
            explicitCompile.extendsFrom(new Configuration[]{implCopy, compileCopy});
        });
        explicitCompile.withDependencies(deps -> {
            explicitCompile.getDependencyConstraints().addAll((Collection)compileClasspath.getAllDependencyConstraints());
            compileClasspath.getExcludeRules().forEach(rule -> explicitCompile.exclude(BaselineExactDependencies.excludeRuleAsMap(rule)));
        });
        AtomicBoolean projectsEvaluated = new AtomicBoolean();
        project.getGradle().projectsEvaluated(g -> projectsEvaluated.set(true));
        explicitCompile.getIncoming().beforeResolve(ir -> Preconditions.checkState((boolean)projectsEvaluated.get(), (String)"Tried to resolve %s too early.", (Object)explicitCompile));
        TaskProvider sourceSetUnusedDependencies = project.getTasks().register(BaselineExactDependencies.checkUnusedDependenciesNameForSourceSet(sourceSet), CheckUnusedDependenciesTask.class, task -> {
            task.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            task.setSourceClasses(sourceSet.getOutput().getClassesDirs());
            task.dependenciesConfiguration(explicitCompile);
            task.ignore("javax.annotation", "javax.annotation-api");
            task.ignore(((CheckUnusedDependenciesParentTask)((Object)((Object)checkUnusedDependencies.get()))).getIgnore());
        });
        checkUnusedDependencies.configure(task -> task.dependsOn(new Object[]{sourceSetUnusedDependencies}));
        TaskProvider sourceSetCheckImplicitDependencies = project.getTasks().register(GUtil.toLowerCamelCase((CharSequence)("checkImplicitDependencies " + sourceSet.getName())), CheckImplicitDependenciesTask.class, task -> {
            task.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            task.setSourceClasses(sourceSet.getOutput().getClassesDirs());
            task.dependenciesConfiguration(compileClasspath);
            task.ignore("org.slf4j", "slf4j-api");
            task.ignore(((CheckImplicitDependenciesParentTask)((Object)((Object)checkImplicitDependencies.get()))).getIgnore());
        });
        checkImplicitDependencies.configure(task -> task.dependsOn(new Object[]{sourceSetCheckImplicitDependencies}));
    }

    static String checkUnusedDependenciesNameForSourceSet(SourceSet sourceSet) {
        return GUtil.toLowerCamelCase((CharSequence)("checkUnusedDependencies " + sourceSet.getName()));
    }

    private static Map<String, String> excludeRuleAsMap(ExcludeRule rule) {
        ImmutableMap.Builder excludeRule = ImmutableMap.builder();
        if (rule.getGroup() != null) {
            excludeRule.put((Object)"group", (Object)rule.getGroup());
        }
        if (rule.getModule() != null) {
            excludeRule.put((Object)"module", (Object)rule.getModule());
        }
        return excludeRule.build();
    }

    public static Stream<String> referencedClasses(File classFile) {
        try {
            return CLASS_FILE_ANALYZER.analyze(classFile.toURI().toURL()).stream();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to analyze " + classFile, e);
        }
    }

    public static String asString(ResolvedArtifact artifact) {
        ModuleVersionIdentifier moduleVersionId = artifact.getModuleVersion().getId();
        StringBuilder builder = new StringBuilder().append(moduleVersionId.getGroup()).append(":").append(moduleVersionId.getName());
        if (artifact.getClassifier() != null) {
            builder.append("::").append(artifact.getClassifier());
        }
        return builder.toString();
    }

    public static String asDependencyStringWithName(ResolvedArtifact artifact) {
        return BaselineExactDependencies.asDependencyString(artifact, true);
    }

    public static String asDependencyStringWithoutName(ResolvedArtifact artifact) {
        return BaselineExactDependencies.asDependencyString(artifact, false);
    }

    private static String asDependencyString(ResolvedArtifact artifact, boolean withName) {
        ComponentIdentifier componentId = artifact.getId().getComponentIdentifier();
        if (componentId instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectComponentId = (ProjectComponentIdentifier)componentId;
            StringBuilder builder = new StringBuilder().append("project('").append(projectComponentId.getProjectPath()).append("')");
            if (withName) {
                builder.append(" (").append(artifact.getId().getDisplayName()).append(")");
            }
            return builder.toString();
        }
        return BaselineExactDependencies.asString(artifact);
    }

    public static String ignoreCoordinate(String group, String name) {
        return group + ":" + name;
    }

    @ThreadSafe
    public static final class Indexes {
        private final Map<String, ResolvedArtifact> classToDependency = new ConcurrentHashMap<String, ResolvedArtifact>();
        private final Map<ResolvedArtifact, Set<String>> classesFromArtifact = new ConcurrentHashMap<ResolvedArtifact, Set<String>>();
        private final Map<ResolvedArtifact, ResolvedDependency> artifactsFromDependency = new ConcurrentHashMap<ResolvedArtifact, ResolvedDependency>();

        public void populateIndexes(Set<ResolvedDependency> declaredDependencies) {
            Set<ResolvedArtifact> allArtifacts = declaredDependencies.stream().flatMap(dependency -> dependency.getAllModuleArtifacts().stream()).filter(dependency -> VALID_ARTIFACT_EXTENSIONS.contains((Object)dependency.getExtension())).collect(Collectors.toSet());
            allArtifacts.forEach(artifact -> {
                try {
                    File jar = artifact.getFile();
                    Set classesInArtifact = JAR_ANALYZER.analyze(jar.toURI().toURL());
                    this.classesFromArtifact.put((ResolvedArtifact)artifact, classesInArtifact);
                    classesInArtifact.forEach(clazz -> this.classToDependency.put((String)clazz, (ResolvedArtifact)artifact));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to analyze artifact", e);
                }
            });
            declaredDependencies.forEach(dependency -> dependency.getModuleArtifacts().forEach(artifact -> this.artifactsFromDependency.put((ResolvedArtifact)artifact, (ResolvedDependency)dependency)));
        }

        public Optional<ResolvedArtifact> classToDependency(String clazz) {
            return Optional.ofNullable(this.classToDependency.get(clazz));
        }

        public Stream<String> classesFromArtifact(ResolvedArtifact resolvedArtifact) {
            return ((Set)Preconditions.checkNotNull(this.classesFromArtifact.get(resolvedArtifact), (Object)"Unable to find resolved artifact")).stream();
        }

        public ResolvedDependency artifactsFromDependency(ResolvedArtifact resolvedArtifact) {
            return (ResolvedDependency)Preconditions.checkNotNull((Object)this.artifactsFromDependency.get(resolvedArtifact), (Object)"Unable to find resolved artifact");
        }
    }
}

