/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Preconditions;
import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import com.palantir.baseline.plugins.BaselineFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;

class BaselineConfig
extends AbstractBaselinePlugin {
    BaselineConfig() {
    }

    public void apply(Project rootProject) {
        this.project = rootProject;
        if (!rootProject.equals(rootProject.getRootProject())) {
            throw new IllegalArgumentException(BaselineConfig.class.getCanonicalName() + " plugin can only be applied to the root project.");
        }
        Configuration configuration = (Configuration)rootProject.getConfigurations().create("baseline");
        Optional<String> version = Optional.ofNullable(this.getClass().getPackage().getImplementationVersion());
        configuration.defaultDependencies(d -> d.add((Object)rootProject.getDependencies().create((Object)String.format("com.palantir.baseline:gradle-baseline-java-config%s@zip", version.map(v -> ":" + v).orElse("")))));
        rootProject.getTasks().register("baselineUpdateConfig", task -> {
            task.setGroup("Baseline");
            task.setDescription("Installs or updates Baseline configuration files in .baseline/");
            task.getInputs().files(new Object[]{configuration});
            task.getOutputs().dir((Object)this.getConfigDir());
            task.getOutputs().dir((Object)rootProject.getRootDir().toPath().resolve("project"));
            task.doLast((Action)new BaselineUpdateConfigAction(configuration, rootProject));
        });
    }

    private class BaselineUpdateConfigAction
    implements Action<Task> {
        private final Configuration configuration;
        private final Project rootProject;

        BaselineUpdateConfigAction(Configuration configuration, Project rootProject) {
            this.configuration = configuration;
            this.rootProject = rootProject;
        }

        public void execute(Task task) {
            if (this.configuration.getFiles().size() != 1) {
                throw new IllegalArgumentException("Expected to find exactly one config dependency in the 'baseline' configuration, found: " + this.configuration.getFiles());
            }
            Path configDir = Paths.get(BaselineConfig.this.getConfigDir(), new String[0]);
            this.rootProject.copy(copySpec -> {
                copySpec.from(new Object[]{this.rootProject.zipTree((Object)this.configuration.getSingleFile())});
                copySpec.into((Object)configDir);
                copySpec.exclude(new String[]{"**/scalastyle_config.xml"});
                copySpec.setIncludeEmptyDirs(false);
                if (!BaselineFormat.eclipseFormattingEnabled(task.getProject())) {
                    copySpec.exclude(new String[]{"**/spotless/eclipse.xml"});
                }
            });
            if (BaselineFormat.palantirJavaFormatterState(this.rootProject) != BaselineFormat.FormatterState.OFF || BaselineConfig.this.project.getPluginManager().hasPlugin("com.palantir.java-format-provider")) {
                Path checkstyleXml = configDir.resolve("checkstyle/checkstyle.xml");
                try {
                    String contents = new String(Files.readAllBytes(checkstyleXml), StandardCharsets.UTF_8);
                    String replaced = contents.replace("        <module name=\"Indentation\"> <!-- Java Style Guide: Block indentation: +4 spaces -->\n            <property name=\"arrayInitIndent\" value=\"8\"/>\n            <property name=\"lineWrappingIndentation\" value=\"8\"/>\n        </module>\n", "").replace("        <module name=\"ParenPad\"/> <!-- Java Style Guide: Horizontal whitespace -->\n", "").replace("        <module name=\"LeftCurly\"/> <!-- Java Style Guide: Nonempty blocks: K & R style -->\n", "");
                    Preconditions.checkState((!contents.equals(replaced) ? 1 : 0) != 0, (Object)"Patching checkstyle.xml must make a change");
                    Files.write(checkstyleXml, replaced.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to patch " + checkstyleXml, e);
                }
            }
            if (this.rootProject.getAllprojects().stream().anyMatch(p -> p.getPluginManager().hasPlugin("scala") && p.getPluginManager().hasPlugin("com.palantir.baseline-scalastyle"))) {
                this.rootProject.copy(copySpec -> {
                    copySpec.from(new Object[]{this.rootProject.zipTree((Object)this.configuration.getSingleFile()).filter(file -> file.getName().equals("scalastyle_config.xml"))});
                    copySpec.into((Object)this.rootProject.getRootDir().toPath().resolve("project"));
                    copySpec.setIncludeEmptyDirs(false);
                });
            }
        }
    }
}

