/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import java.nio.file.Paths;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;

public final class BaselineCheckstyle
extends AbstractBaselinePlugin {
    private static final String DEFAULT_CHECKSTYLE_VERSION = "8.33";

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(CheckstylePlugin.class);
        project.getExtensions().configure(CheckstyleExtension.class, ext -> ext.setToolVersion(DEFAULT_CHECKSTYLE_VERSION));
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            if (javaConvention.getSourceCompatibility().isJava8Compatible()) {
                project.getTasks().withType(Javadoc.class, javadoc -> javadoc.options(javadocOptions -> ((StandardJavadocDocletOptions)javadocOptions).addStringOption("Xdoclint:none", "-quiet")));
            }
        });
        ((CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class)).getConfigDirectory().set(this.project.file((Object)Paths.get(this.getConfigDir(), "checkstyle").toString()));
        project.getPluginManager().withPlugin("eclipse", plugin -> {
            EclipseProject eclipseProject = ((EclipseModel)project.getExtensions().getByType(EclipseModel.class)).getProject();
            eclipseProject.buildCommand("net.sf.eclipsecs.core.CheckstyleBuilder");
        });
    }
}

