/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="TooManyArguments", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer Interface that take few arguments rather than many.")
@AutoService(value={BugChecker.class})
public final class TooManyArguments
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final int MAX_NUM_ARGS = 10;
    private static final Matcher<Tree> IS_OVERRIDE = Matchers.hasAnnotation(Override.class);

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (IS_OVERRIDE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null || symbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        if (tree.getParameters().size() > 10) {
            return this.buildDescription(tree).setMessage("Interfaces can take at most 10 arguments. Consider the following ways of solving the problem:\n- Define an object with Immutables that contains all of the arguments\n- Expose smaller interfaces by refactorings concepts into separate interfaces").build();
        }
        return Description.NO_MATCH;
    }
}

