/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreASTHelpers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(name="ThrowSpecificity", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer to declare more specific throws types than Exception and Throwable. When methods are updated to throw new checked exceptions they expect callers to handle failure types explicitly. Throwing broad types defeats the type system. By throwing the most specific types possible we leverage existing compiler functionality to detect unreachable code.\nNote: Checked exceptions are only validated by the compiler and can be thrown by non-standard bytecode at runtime, for example when java code calls into groovy or scala generated bytecode a checked exception can be thrown despite not being declared. In these scenarios we recommend suppressing this check using @SuppressWarnings(\"ThrowSpecificity\") and a comment describing the reason. Remaining instances can be automatically fixed using ./gradlew compileJava -PerrorProneApply=ThrowSpecificity")
@AutoService(value={BugChecker.class})
public final class ThrowSpecificity
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final int MAX_CHECKED_EXCEPTIONS = 3;

    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<? extends ExpressionTree> throwsExpressions = tree.getThrows();
        if (throwsExpressions.size() != 1 || !ThrowSpecificity.safeToModifyThrowsClause(tree)) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        if (ASTHelpers.findSuperMethod((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree), (Types)types).isPresent()) {
            return Description.NO_MATCH;
        }
        ExpressionTree throwsExpression = (ExpressionTree)Iterables.getOnlyElement(throwsExpressions);
        Type throwsExpressionType = ASTHelpers.getType((Tree)throwsExpression);
        if (throwsExpressionType == null || !ThrowSpecificity.isBroadException(throwsExpressionType, state)) {
            return Description.NO_MATCH;
        }
        ImmutableSet allThrownExceptions = ASTHelpers.getThrownExceptions((Tree)tree.getBody(), (VisitorState)state);
        ImmutableList normalizedThrownExceptions = (ImmutableList)allThrownExceptions.stream().filter(type -> ASTHelpers.isCheckedExceptionType((Type)type, (VisitorState)state)).collect(ImmutableList.toImmutableList());
        ImmutableList<Type> checkedExceptions = MoreASTHelpers.flattenTypesForAssignment((ImmutableList<Type>)normalizedThrownExceptions, state);
        if (checkedExceptions.size() > 3 || ThrowSpecificity.containsBroadException(checkedExceptions, state) || TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        if (checkedExceptions.isEmpty()) {
            return this.buildDescription(throwsExpression).addFix(SuggestedFixes.deleteExceptions((MethodTree)tree, (VisitorState)state, (List)ImmutableList.of((Object)throwsExpression))).build();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return this.buildDescription(throwsExpression).addFix((Fix)fix.replace((Tree)throwsExpression, checkedExceptions.stream().map(checkedException -> SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)checkedException)).collect(Collectors.joining(", "))).build()).build();
    }

    private static boolean safeToModifyThrowsClause(MethodTree tree) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null) {
            return false;
        }
        Set<Modifier> methodModifiers = symbol.getModifiers();
        if (symbol.isPrivate()) {
            return true;
        }
        return !methodModifiers.contains((Object)Modifier.ABSTRACT) && !methodModifiers.contains((Object)Modifier.PUBLIC) && (symbol.isStatic() || methodModifiers.contains((Object)Modifier.FINAL) || ASTHelpers.enclosingClass((Symbol)symbol).getModifiers().contains((Object)Modifier.FINAL));
    }

    private static boolean containsBroadException(Collection<Type> exceptions, VisitorState state) {
        return exceptions.stream().anyMatch(type -> ThrowSpecificity.isBroadException(type, state));
    }

    private static boolean isBroadException(Type type, VisitorState state) {
        return ASTHelpers.isSameType((Type)state.getTypeFromString(Exception.class.getName()), (Type)type, (VisitorState)state) || ASTHelpers.isSameType((Type)state.getTypeFromString(Throwable.class.getName()), (Type)type, (VisitorState)state);
    }
}

