/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="Slf4jThrowable", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Slf4j loggers require throwables to be the last parameter otherwise a stack trace is not produced. Documentation is available here: http://www.slf4j.org/faq.html#paramException")
@AutoService(value={BugChecker.class})
public final class Slf4jThrowable
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> THROWABLE = MoreMatchers.isSubtypeOf(Throwable.class);
    private static final Matcher<ExpressionTree> LOG_METHOD = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").withNameMatching(Pattern.compile("trace|debug|info|warn|error"));
    private static final Matcher<ExpressionTree> CORRECT_THROWABLE = Matchers.methodInvocation(LOG_METHOD, (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.LAST, THROWABLE);
    private static final Matcher<ExpressionTree> ANY_THROWABLE = Matchers.methodInvocation(LOG_METHOD, (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, THROWABLE);
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(CORRECT_THROWABLE), ANY_THROWABLE});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ANY_THROWABLE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        int lastIndex = arguments.size() - 1;
        int throwableIndex = Slf4jThrowable.getFirstThrowableArgumentIndex(arguments, state);
        if (throwableIndex == lastIndex) {
            return Description.NO_MATCH;
        }
        if (Slf4jThrowable.countThrowableArguments(arguments, state) > 1) {
            return this.describeMatch(arguments.get(throwableIndex));
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (int i = throwableIndex; i < lastIndex; ++i) {
            fix.replace((Tree)arguments.get(i), state.getSourceForNode((Tree)arguments.get(i + 1)));
        }
        ExpressionTree throwableArgument = arguments.get(throwableIndex);
        return this.buildDescription(throwableArgument).addFix((Fix)fix.replace((Tree)arguments.get(lastIndex), state.getSourceForNode((Tree)throwableArgument)).build()).build();
    }

    private static int getFirstThrowableArgumentIndex(List<? extends ExpressionTree> arguments, VisitorState state) {
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionTree argument = arguments.get(i);
            if (!THROWABLE.matches((Tree)argument, state)) continue;
            return i;
        }
        throw new IllegalStateException("Failed to find a throwable argument");
    }

    private static int countThrowableArguments(List<? extends ExpressionTree> arguments, VisitorState state) {
        int count = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            if (!THROWABLE.matches((Tree)arguments.get(i), state)) continue;
            ++count;
        }
        return count;
    }
}

