/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="SafeLoggingExceptionMessageFormat", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="SafeLoggable exceptions do not interpolate parameters")
@AutoService(value={BugChecker.class})
public final class SafeLoggingExceptionMessageFormat
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> STANDARD_SAFE_LOGGABLE_EXCEPTIONS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((String)"com.palantir.logsafe.exceptions.SafeIllegalArgumentException"), Matchers.isSameType((String)"com.palantir.logsafe.exceptions.SafeIllegalStateException"), Matchers.isSameType((String)"com.palantir.logsafe.exceptions.SafeIoException"), Matchers.isSameType((String)"com.palantir.logsafe.exceptions.SafeNullPointerException"), Matchers.isSameType((String)"com.palantir.logsafe.exceptions.SafeRuntimeException")});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!STANDARD_SAFE_LOGGABLE_EXCEPTIONS.matches((Tree)tree.getIdentifier(), state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.isEmpty()) {
            return Description.NO_MATCH;
        }
        ExpressionTree messageArg = args.get(0);
        if (!messageArg.getKind().equals((Object)Tree.Kind.STRING_LITERAL)) {
            return Description.NO_MATCH;
        }
        if (!(messageArg instanceof LiteralTree)) {
            return Description.NO_MATCH;
        }
        LiteralTree literalTreeMessageArg = (LiteralTree)messageArg;
        Object value = literalTreeMessageArg.getValue();
        if (!(value instanceof String)) {
            return Description.NO_MATCH;
        }
        String message = (String)value;
        if (message.contains("{}")) {
            return this.buildDescription(tree).setMessage("Do not use slf4j-style formatting in logsafe Exceptions. Logsafe exceptions provide a simple message and key-value pairs of arguments, no interpolation is performed.").build();
        }
        return Description.NO_MATCH;
    }
}

