/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Locale;
import javax.lang.model.element.Modifier;

@BugPattern(name="RedundantModifier", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Avoid using redundant modifiers")
@AutoService(value={BugChecker.class})
public final class RedundantModifier
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<ClassTree> STATIC_ENUM_OR_INTERFACE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.ENUM), Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE)}), MoreMatchers.hasExplicitModifier(Modifier.STATIC)});
    private static final Matcher<MethodTree> PRIVATE_ENUM_CONSTRUCTOR = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.ENUM)), MoreMatchers.hasExplicitModifier(Modifier.PRIVATE)});
    private static final Matcher<MethodTree> STATIC_FINAL_METHOD = Matchers.allOf((Matcher[])new Matcher[]{MoreMatchers.hasExplicitModifier(Modifier.STATIC), MoreMatchers.hasExplicitModifier(Modifier.FINAL)});
    private static final Matcher<MethodTree> UNNECESSARY_INTERFACE_METHOD_MODIFIERS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE)), Matchers.not((Matcher)Matchers.isStatic()), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.DEFAULT)), Matchers.anyOf((Matcher[])new Matcher[]{MoreMatchers.hasExplicitModifier(Modifier.PUBLIC), MoreMatchers.hasExplicitModifier(Modifier.ABSTRACT)})});
    private static final Matcher<MethodTree> INTERFACE_STATIC_METHOD_MODIFIERS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE)), Matchers.isStatic(), MoreMatchers.hasExplicitModifier(Modifier.PUBLIC)});
    private static final Matcher<VariableTree> INTERFACE_FIELD_MODIFIERS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE)), Matchers.isStatic(), Matchers.anyOf((Matcher[])new Matcher[]{MoreMatchers.hasExplicitModifier(Modifier.PUBLIC), MoreMatchers.hasExplicitModifier(Modifier.STATIC), MoreMatchers.hasExplicitModifier(Modifier.FINAL)})});
    private static final Matcher<VariableTree> ABSTRACT_METHOD_MODIFIERS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingNode((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.METHOD), Matchers.hasModifier((Modifier)Modifier.ABSTRACT)})), MoreMatchers.hasExplicitModifier(Modifier.FINAL)});
    private static final Matcher<ClassTree> INTERFACE_NESTED_CLASS_MODIFIERS = Matchers.allOf((Matcher[])new Matcher[]{MoreMatchers.classEnclosingClass((Matcher<ClassTree>)Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE)), Matchers.anyOf((Matcher[])new Matcher[]{MoreMatchers.hasExplicitModifier(Modifier.PUBLIC), MoreMatchers.hasExplicitModifier(Modifier.STATIC)})});
    private static final Matcher<MethodTree> UNNECESSARY_FINAL_METHOD_ON_FINAL_CLASS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.isStatic()), Matchers.enclosingClass((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.CLASS), MoreMatchers.hasExplicitModifier(Modifier.FINAL)})), Matchers.allOf((Matcher[])new Matcher[]{MoreMatchers.hasExplicitModifier(Modifier.FINAL), Matchers.not((Matcher)Matchers.hasAnnotation(SafeVarargs.class))})});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (INTERFACE_NESTED_CLASS_MODIFIERS.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Types nested in interfaces are public and static by default.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).build();
        }
        if (STATIC_ENUM_OR_INTERFACE.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage(tree.getKind().name().toLowerCase(Locale.ENGLISH) + "s are static by default. The 'static' modifier is unnecessary.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC})).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (PRIVATE_ENUM_CONSTRUCTOR.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Enum constructors are private by default. The 'private' modifier is unnecessary.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PRIVATE})).build();
        }
        if (STATIC_FINAL_METHOD.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Static methods cannot be overridden. The 'final' modifier is unnecessary.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        if (UNNECESSARY_INTERFACE_METHOD_MODIFIERS.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Interface methods are public and abstract by default. The 'public' and 'abstract' modifiers are unnecessary.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT})).build();
        }
        if (INTERFACE_STATIC_METHOD_MODIFIERS.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Interface components are public by default. The 'public' modifier is unnecessary.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC})).build();
        }
        if (UNNECESSARY_FINAL_METHOD_ON_FINAL_CLASS.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Redundant 'final' modifier on an instance method of a final class.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (INTERFACE_FIELD_MODIFIERS.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Interface fields are public, static, and final by default. These modifiers are unnecessary to specify.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL})).build();
        }
        if (ABSTRACT_METHOD_MODIFIERS.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("The final modifier has no impact on abstract methods.").addFix(SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        return Description.NO_MATCH;
    }
}

