/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@BugPattern(name="OptionalFlatMapOfNullable", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Optional.map functions may return null to safely produce an empty result.")
@AutoService(value={BugChecker.class})
public final class OptionalFlatMapOfNullable
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> flatMap = MethodMatchers.instanceMethod().onDescendantOf(Optional.class.getName()).named("flatMap").withParameters(new String[]{Function.class.getName()});
    private static final Matcher<ExpressionTree> ofNullable = MethodMatchers.staticMethod().onClass(Optional.class.getName()).named("ofNullable").withParameters(new String[]{Object.class.getName()});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!flatMap.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree functionParameter = ASTHelpers.stripParentheses((ExpressionTree)tree.getArguments().get(0));
        if (functionParameter.getKind() != Tree.Kind.LAMBDA_EXPRESSION) {
            return Description.NO_MATCH;
        }
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)functionParameter;
        Optional<ExpressionTree> maybeExpression = this.finalExpression(lambdaExpressionTree);
        if (!maybeExpression.isPresent()) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = maybeExpression.get();
        if (!ofNullable.matches((Tree)expression, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree ofNullableInvocation = (MethodInvocationTree)expression;
        ExpressionTree ofNullableArg = ofNullableInvocation.getArguments().get(0);
        return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"map", (VisitorState)state)).replace((Tree)ofNullableInvocation, state.getSourceForNode((Tree)ofNullableArg)).build()).build();
    }

    private Optional<ExpressionTree> finalExpression(LambdaExpressionTree lambdaExpressionTree) {
        Tree body = lambdaExpressionTree.getBody();
        switch (lambdaExpressionTree.getBodyKind()) {
            case EXPRESSION: {
                return Optional.of((ExpressionTree)body);
            }
            case STATEMENT: {
                StatementTree finalStatement;
                BlockTree block;
                List<? extends StatementTree> statements;
                if (!(body instanceof BlockTree) || (statements = (block = (BlockTree)body).getStatements()).isEmpty() || !((finalStatement = statements.get(statements.size() - 1)) instanceof ReturnTree)) break;
                ReturnTree returnTree = (ReturnTree)finalStatement;
                return Optional.ofNullable(returnTree.getExpression());
            }
        }
        return Optional.empty();
    }
}

