/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.stream.Stream;

@BugPattern(name="NonComparableStreamSort", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Stream.sorted() should only be called on streams of Comparable types.")
@AutoService(value={BugChecker.class})
public final class NonComparableStreamSort
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> SORTED_CALL_ON_JAVA_STREAM_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).named("sorted").withParameters(new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SORTED_CALL_ON_JAVA_STREAM_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type returnType = ASTHelpers.getReturnType((ExpressionTree)tree);
        if (returnType == null) {
            return Description.NO_MATCH;
        }
        Symbol streamSymbol = state.getSymbolFromString(Stream.class.getName());
        if (streamSymbol == null) {
            return Description.NO_MATCH;
        }
        Type streamType = state.getTypes().asSuper(returnType, streamSymbol);
        if (streamType.getTypeArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        Type streamParameterType = (Type)Iterables.getOnlyElement(streamType.getTypeArguments());
        if (ASTHelpers.isSubtype((Type)streamParameterType, (Type)state.getTypeFromString(Comparable.class.getName()), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Stream.sorted() should only be called on streams of Comparable types.").build();
    }
}

