/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="LambdaMethodReference", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Lambda should be a method reference")
@AutoService(value={BugChecker.class})
public final class LambdaMethodReference
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        LambdaExpressionTree.BodyKind bodyKind = tree.getBodyKind();
        Tree body = tree.getBody();
        switch (bodyKind) {
            case EXPRESSION: {
                if (!(body instanceof MethodInvocationTree)) {
                    return Description.NO_MATCH;
                }
                return this.checkMethodInvocation((MethodInvocationTree)body, tree, state);
            }
            case STATEMENT: {
                if (!(body instanceof BlockTree)) {
                    return Description.NO_MATCH;
                }
                BlockTree block = (BlockTree)body;
                if (block.getStatements().size() != 1) {
                    return Description.NO_MATCH;
                }
                StatementTree statement = block.getStatements().get(0);
                if (!(statement instanceof ReturnTree)) {
                    return Description.NO_MATCH;
                }
                ReturnTree returnStatement = (ReturnTree)statement;
                ExpressionTree returnExpression = returnStatement.getExpression();
                if (!(returnExpression instanceof MethodInvocationTree)) {
                    return Description.NO_MATCH;
                }
                return this.checkMethodInvocation((MethodInvocationTree)returnExpression, tree, state);
            }
        }
        throw new IllegalStateException("Unexpected BodyKind: " + (Object)((Object)bodyKind));
    }

    private Description checkMethodInvocation(MethodInvocationTree methodInvocation, LambdaExpressionTree root, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocation);
        if (methodSymbol == null || !methodInvocation.getTypeArguments().isEmpty() || LambdaMethodReference.hasExplicitParameterTypes(root, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocation);
        boolean isLocal = LambdaMethodReference.isLocal(methodInvocation);
        if (!isLocal && !(receiver instanceof IdentifierTree)) {
            return Description.NO_MATCH;
        }
        if (methodInvocation.getArguments().isEmpty() && root.getParameters().size() == 1) {
            return this.convertVariableInstanceMethods(methodSymbol, methodInvocation, root, state);
        }
        if (methodInvocation.getArguments().size() == root.getParameters().size()) {
            return this.convertMethodInvocations(methodSymbol, methodInvocation, root, state);
        }
        return Description.NO_MATCH;
    }

    private static boolean hasExplicitParameterTypes(LambdaExpressionTree lambda, VisitorState state) {
        for (VariableTree variableTree : lambda.getParameters()) {
            boolean expectComma = false;
            for (ErrorProneToken token : state.getTokensForNode((Tree)variableTree)) {
                if (token.kind() == Tokens.TokenKind.EOF) {
                    return false;
                }
                if (token.kind() == Tokens.TokenKind.IDENTIFIER && expectComma || token.kind() == Tokens.TokenKind.COMMA && !expectComma) {
                    return true;
                }
                expectComma = !expectComma;
            }
        }
        return false;
    }

    private Description convertVariableInstanceMethods(Symbol.MethodSymbol methodSymbol, MethodInvocationTree methodInvocation, LambdaExpressionTree root, VisitorState state) {
        Symbol receiverSymbol;
        Symbol.VarSymbol paramSymbol = ASTHelpers.getSymbol((VariableTree)((VariableTree)Iterables.getOnlyElement(root.getParameters())));
        if (!paramSymbol.equals(receiverSymbol = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)methodInvocation)))) {
            return Description.NO_MATCH;
        }
        return LambdaMethodReference.buildFix(methodSymbol, methodInvocation, root, state, LambdaMethodReference.isLocal(methodInvocation)).map(fix -> this.buildDescription(root).addFix((Fix)fix).build()).orElse(Description.NO_MATCH);
    }

    private Description convertMethodInvocations(Symbol.MethodSymbol methodSymbol, MethodInvocationTree methodInvocation, LambdaExpressionTree root, VisitorState state) {
        java.util.List<Symbol> lambdaParam;
        java.util.List<Symbol> methodParams = LambdaMethodReference.getSymbols(methodInvocation.getArguments());
        if (!methodParams.equals(lambdaParam = LambdaMethodReference.getSymbols(root.getParameters()))) {
            return Description.NO_MATCH;
        }
        return LambdaMethodReference.buildFix(methodSymbol, methodInvocation, root, state, LambdaMethodReference.isLocal(methodInvocation)).filter(fix -> SuggestedFixes.compilesWithFix((Fix)fix, (VisitorState)state)).map(fix -> this.buildDescription(root).addFix((Fix)fix).build()).orElse(Description.NO_MATCH);
    }

    private static java.util.List<Symbol> getSymbols(java.util.List<? extends Tree> params) {
        return (java.util.List)params.stream().map(ASTHelpers::getSymbol).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private static Optional<SuggestedFix> buildFix(Symbol.MethodSymbol symbol, MethodInvocationTree invocation, LambdaExpressionTree root, VisitorState state, boolean isLocal) {
        if (LambdaMethodReference.isAmbiguousMethod(symbol, ASTHelpers.getReceiver((ExpressionTree)invocation), state)) {
            return Optional.empty();
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        return LambdaMethodReference.qualifyTarget(symbol, invocation, root, builder, state, isLocal).flatMap(LambdaMethodReference::toMethodReference).map(qualified -> builder.replace((Tree)root, qualified).build());
    }

    private static boolean isAmbiguousMethod(Symbol.MethodSymbol symbol, @Nullable ExpressionTree receiver, VisitorState state) {
        if (symbol.isStatic()) {
            if (symbol.params().size() != 1) {
                return false;
            }
            Symbol.ClassSymbol classSymbol = ASTHelpers.enclosingClass((Symbol)symbol);
            if (classSymbol == null) {
                return false;
            }
            Set matching = ASTHelpers.findMatchingMethods((Name)symbol.name, sym -> sym != null && !sym.isStatic() && ((List)sym.getParameters()).isEmpty(), (Type)classSymbol.type, (Types)state.getTypes());
            return !matching.isEmpty();
        }
        if (!symbol.params().isEmpty()) {
            return false;
        }
        if (receiver == null) {
            return false;
        }
        Type receiverType = ASTHelpers.getType((Tree)receiver);
        if (receiverType == null) {
            return false;
        }
        Set matching = ASTHelpers.findMatchingMethods((Name)symbol.name, sym -> sym != null && sym.isStatic() && ((List)sym.getParameters()).size() == 1 && state.getTypes().isAssignable(state.getTypes().erasure(receiverType), state.getTypes().erasure(sym.params().get((int)0).type)), (Type)receiverType, (Types)state.getTypes());
        return !matching.isEmpty();
    }

    private static Optional<String> qualifyTarget(Symbol.MethodSymbol symbol, MethodInvocationTree invocation, LambdaExpressionTree root, SuggestedFix.Builder builder, VisitorState state, boolean isLocal) {
        if (!symbol.isStatic() && isLocal) {
            ClassTree enclosingClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
            if (enclosingClass == null) {
                return Optional.empty();
            }
            Type.ClassType enclosingType = ASTHelpers.getType((ClassTree)enclosingClass);
            if (!ASTHelpers.findMatchingMethods((Name)symbol.name, symbol::equals, (Type)enclosingType, (Types)state.getTypes()).isEmpty()) {
                return Optional.of("this." + symbol.name.toString());
            }
            return Optional.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)invocation);
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)invocation);
        if (receiverType == null || receiverType.getLowerBound() != null || receiverType.getUpperBound() != null) {
            return Optional.of(SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (Symbol)symbol));
        }
        Symbol receiverSymbol = ASTHelpers.getSymbol((Tree)receiver);
        if (!symbol.isStatic() && receiver instanceof IdentifierTree && !Objects.equals(ImmutableList.of((Object)receiverSymbol), LambdaMethodReference.getSymbols(root.getParameters()))) {
            if (!LambdaMethodReference.isFinal(receiverSymbol)) {
                return Optional.empty();
            }
            return Optional.of(state.getSourceForNode((Tree)receiver) + '.' + symbol.name.toString());
        }
        return Optional.of(SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (TypeMirror)state.getTypes().erasure(receiverType)) + '.' + symbol.name.toString());
    }

    private static Optional<String> toMethodReference(String qualifiedMethodName) {
        int index = qualifiedMethodName.lastIndexOf(46);
        if (index > 0) {
            return Optional.of(qualifiedMethodName.substring(0, index) + "::" + qualifiedMethodName.substring(index + 1));
        }
        return Optional.empty();
    }

    private static boolean isLocal(MethodInvocationTree methodInvocationTree) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        return receiver == null || receiver instanceof IdentifierTree && "this".equals(((IdentifierTree)receiver).getName().toString());
    }

    private static boolean isFinal(Symbol symbol) {
        return (symbol.flags() & 0x20000000010L) != 0L;
    }
}

