/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StreamResourceLeak;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="JooqResultStreamLeak", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Methods that return an autocloseable resource on jOOQ's ResultQuery should be closed using try-with-resources. Not doing so can result in leaked database resources (such as connections or cursors) in code paths that throw an exception or fail to call #close().")
@AutoService(value={BugChecker.class})
public final class JooqResultStreamLeak
extends StreamResourceLeak {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onDescendantOf("org.jooq.ResultQuery").withAnyName();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (!JooqResultStreamLeak.shouldBeAutoClosed(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state, this.findingPerSite());
    }

    private static boolean shouldBeAutoClosed(MethodInvocationTree tree, VisitorState state) {
        Type returnType = ASTHelpers.getReturnType((ExpressionTree)tree);
        boolean isAutoCloseable = ASTHelpers.isSubtype((Type)returnType, (Type)state.getTypeFromString(AutoCloseable.class.getName()), (VisitorState)state);
        boolean isJooqQuery = ASTHelpers.isSubtype((Type)returnType, (Type)state.getTypeFromString("org.jooq.QueryPart"), (VisitorState)state);
        return isAutoCloseable && !isJooqQuery;
    }
}

