/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(name="ImplicitPublicBuilderConstructor", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="A Builder with a static factory method on the encapsulating class must have a private constructor. Minimizing unnecessary public API prevents future API breaks from impacting consumers. ")
@AutoService(value={BugChecker.class})
public final class ImplicitPublicBuilderConstructor
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((ClassTree)tree));
        if (enclosingClass == null) {
            return Description.NO_MATCH;
        }
        if (!ImplicitPublicBuilderConstructor.isValidBuilderClass(tree)) {
            return Description.NO_MATCH;
        }
        List constructors = ASTHelpers.getConstructors((ClassTree)tree);
        if (constructors.size() != 1 || !ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)Iterables.getOnlyElement((Iterable)constructors)))) {
            return Description.NO_MATCH;
        }
        if (!ImplicitPublicBuilderConstructor.hasStaticBuilderFactory(enclosingClass, tree, state)) {
            return Description.NO_MATCH;
        }
        int constructorPosition = ((JCTree)((Object)tree)).getStartPosition() + state.getSourceForNode((Tree)tree).indexOf(123) + 1;
        for (Tree tree2 : tree.getMembers()) {
            int endPosition;
            if (tree2.getKind() != Tree.Kind.VARIABLE || (endPosition = state.getEndPosition(tree2)) <= constructorPosition) continue;
            constructorPosition = endPosition;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().replace(constructorPosition, constructorPosition, String.format("\nprivate %s() {}", tree.getSimpleName())).build()).build();
    }

    private static boolean isValidBuilderClass(ClassTree tree) {
        return tree.getSimpleName().contentEquals("Builder") && tree.getImplementsClause().isEmpty() && tree.getExtendsClause() == null && tree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
    }

    private static boolean hasStaticBuilderFactory(Symbol.ClassSymbol classSymbol, ClassTree builderClassTree, VisitorState state) {
        Set matching = ASTHelpers.findMatchingMethods((Name)state.getName("builder"), methodSymbol -> methodSymbol != null && methodSymbol.isStatic() && ASTHelpers.isSameType((Type)ASTHelpers.getType((ClassTree)builderClassTree), (Type)methodSymbol.getReturnType(), (VisitorState)state), (Type)classSymbol.type, (Types)state.getTypes());
        return !matching.isEmpty();
    }
}

