/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.ElementPredicates;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Element;
import org.immutables.value.Value;

@BugPattern(name="ImmutablesStyle", linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", severity=BugPattern.SeverityLevel.WARNING, summary="Using an inline Immutables @Value.Style annotation or meta-annotation with non-SOURCE retention forces consumers to add a Immutables annotations to their compile classpath.Instead use a meta-annotation with SOURCE retention.See https://github.com/immutables/immutables/issues/291.")
@AutoService(value={BugChecker.class})
public final class ImmutablesStyle
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> STYLE_ANNOTATION = Matchers.hasAnnotation(Value.Style.class);

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!STYLE_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        switch (tree.getKind()) {
            case CLASS: 
            case INTERFACE: {
                return this.describeMatch(tree);
            }
            case ANNOTATION_TYPE: {
                Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
                if (ElementPredicates.hasSourceRetention((Element)classSymbol)) break;
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }
}

