/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(name="FinalClass", altNames={"checkstyle:finalclass", "checkstyle:FinalClass"}, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="A class should be declared final if all of its constructors are private. Utility classes -- i.e., classes all of whose methods and fields are static -- have a private, empty, zero-argument constructor.\nhttps://github.com/palantir/gradle-baseline/tree/develop/docs/best-practices/java-coding-guidelines#private-constructors")
@AutoService(value={BugChecker.class})
public final class FinalClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> SIMPLIFIABLE_INSTANCE_METHOD = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.FINAL), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.STATIC)), Matchers.not((Matcher)Matchers.hasAnnotation(SafeVarargs.class))});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.CLASS) {
            return Description.NO_MATCH;
        }
        Set<Modifier> classModifiers = tree.getModifiers().getFlags();
        if (classModifiers.contains((Object)Modifier.FINAL) || classModifiers.contains((Object)Modifier.ABSTRACT)) {
            return Description.NO_MATCH;
        }
        List constructors = ASTHelpers.getConstructors((ClassTree)tree);
        if (constructors.isEmpty()) {
            return Description.NO_MATCH;
        }
        for (MethodTree constructor : constructors) {
            if (constructor.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) continue;
            return Description.NO_MATCH;
        }
        if (FinalClass.isClassExtendedInternally(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix(FinalClass.buildFix(tree, state)).build();
    }

    private static Optional<SuggestedFix> buildFix(ClassTree tree, VisitorState state) {
        return SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).map(fix -> {
            SuggestedFix.Builder builder = SuggestedFix.builder().merge(fix);
            tree.getMembers().stream().filter(member -> member instanceof MethodTree).map(MethodTree.class::cast).filter(methodTree -> SIMPLIFIABLE_INSTANCE_METHOD.matches((Tree)methodTree, state)).forEach(methodTree -> SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)builder).merge(arg_0)));
            return builder.build();
        });
    }

    private static boolean isClassExtendedInternally(final ClassTree tree, final VisitorState state) {
        for (Tree tree2 : state.getPath().getCompilationUnit().getTypeDecls()) {
            Boolean maybeResult = tree2.accept(new TreeScanner<Boolean, Void>(){

                @Override
                public Boolean reduce(Boolean lhs, Boolean rhs) {
                    return Boolean.TRUE.equals(lhs) || Boolean.TRUE.equals(rhs);
                }

                @Override
                public Boolean visitClass(ClassTree classTree, Void attachment) {
                    Tree extendsClause = classTree.getExtendsClause();
                    if (extendsClause != null && ASTHelpers.isSameType((Type)ASTHelpers.getType((ClassTree)tree), (Type)ASTHelpers.getType((Tree)extendsClause), (VisitorState)state)) {
                        return true;
                    }
                    return (Boolean)super.visitClass(classTree, attachment);
                }

                @Override
                public Boolean visitNewClass(NewClassTree newClassTree, Void attachment) {
                    if (newClassTree.getClassBody() != null && ASTHelpers.isSameType((Type)ASTHelpers.getType((ClassTree)tree), (Type)ASTHelpers.getType((Tree)newClassTree.getIdentifier()), (VisitorState)state)) {
                        return true;
                    }
                    return (Boolean)super.visitNewClass(newClassTree, attachment);
                }
            }, null);
            if (!Boolean.TRUE.equals(maybeResult)) continue;
            return true;
        }
        return false;
    }
}

