/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Filter;

@BugPattern(name="ClassInitializationDeadlock", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Static fields and blocks within a class must not require a subclass, otherwise a deadlock occurs when separate threads simultaneously attempt to initialize the subclass and base class. This behavior is allowed by the java language specification and is not considered a Java bug.\nFrom https://docs.oracle.com/javase/specs/jls/se8/html/jls-12.html#jls-12.4.1\n> 12.4.1. When Initialization Occurs\n> A class or interface type T will be initialized immediately before the first occurrence of any one of the following:\n> \u2022 T is a class and an instance of T is created.\n> \u2022 A static method declared by T is invoked.\n> \u2022 A static field declared by T is assigned.\n> \u2022 A static field declared by T is used and the field is not a constant variable (\u00a74.12.4).\n> \u2022 T is a top level class (\u00a77.6) and an assert statement (\u00a714.10) lexically nested within T (\u00a78.1.3) is executed.")
@AutoService(value={BugChecker.class})
public final class ClassInitializationDeadlock
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        SubtypeInitializationVisitor visitor = new SubtypeInitializationVisitor(ASTHelpers.getType((ClassTree)tree));
        for (Tree tree2 : tree.getMembers()) {
            switch (tree2.getKind()) {
                case VARIABLE: {
                    VariableTree variableTree = (VariableTree)tree2;
                    ExpressionTree initializer = variableTree.getInitializer();
                    if (initializer == null || !ASTHelpers.getSymbol((VariableTree)variableTree).isStatic()) break;
                    initializer.accept(visitor, state);
                    break;
                }
                case BLOCK: {
                    tree2.accept(visitor, state);
                    break;
                }
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean isSubtype(Type maybeSubtype, Type baseType, VisitorState state) {
        if (maybeSubtype == null || baseType == null) {
            return false;
        }
        return ASTHelpers.isSubtype((Type)maybeSubtype, (Type)baseType, (VisitorState)state) && !ASTHelpers.isSameType((Type)maybeSubtype, (Type)baseType, (VisitorState)state);
    }

    private static enum CanBeExternallyInitializedFilter implements Filter<Symbol>
    {
        INSTANCE;


        public boolean accepts(Symbol symbol) {
            switch (symbol.getKind()) {
                case FIELD: 
                case METHOD: {
                    if (!symbol.isStatic() || symbol.isPrivate()) break;
                    return true;
                }
                case CONSTRUCTOR: {
                    if (symbol.isPrivate()) break;
                    return true;
                }
            }
            return false;
        }
    }

    private final class SubtypeInitializationVisitor
    extends TreeScanner<Void, VisitorState> {
        private final Type baseType;

        SubtypeInitializationVisitor(Type baseType) {
            this.baseType = baseType;
        }

        @Override
        public Void visitNewClass(NewClassTree node, VisitorState state) {
            if (ClassInitializationDeadlock.isSubtype(ASTHelpers.getType((Tree)node), this.baseType, state) && !ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)node.getIdentifier()), (Type)this.baseType, (VisitorState)state) && !this.isPrivateEncapsulated(node)) {
                state.reportMatch(ClassInitializationDeadlock.this.describeMatch(node));
                return null;
            }
            return (Void)super.visitNewClass(node, state);
        }

        private boolean isPrivateEncapsulated(NewClassTree node) {
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((NewClassTree)node);
            if (methodSymbol == null) {
                return false;
            }
            Symbol.ClassSymbol newClassSymbol = methodSymbol.enclClass();
            if (!newClassSymbol.getQualifiedName().startsWith(this.baseType.tsym.getQualifiedName())) {
                return false;
            }
            return this.cannotBeInitializedExternally(newClassSymbol);
        }

        private boolean cannotBeInitializedExternally(Symbol.ClassSymbol newClassSymbol) {
            if (newClassSymbol.isPrivate()) {
                return true;
            }
            return !newClassSymbol.members().getSymbols(CanBeExternallyInitializedFilter.INSTANCE, Scope.LookupKind.NON_RECURSIVE).iterator().hasNext();
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)node);
            if (methodSymbol != null && methodSymbol.isStatic() && ClassInitializationDeadlock.isSubtype(ASTHelpers.enclosingClass((Symbol)methodSymbol).type, this.baseType, state)) {
                state.reportMatch(ClassInitializationDeadlock.this.describeMatch(node));
                return null;
            }
            if (ClassInitializationDeadlock.isSubtype(ASTHelpers.getResultType((ExpressionTree)node), this.baseType, state)) {
                state.reportMatch(ClassInitializationDeadlock.this.describeMatch(node));
                return null;
            }
            return (Void)super.visitMethodInvocation(node, state);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, VisitorState state) {
            if (this.handleAssignment(node.getVariable(), state)) {
                return null;
            }
            return (Void)super.visitAssignment(node, state);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, VisitorState state) {
            if (this.handleAssignment(node.getVariable(), state)) {
                return null;
            }
            return (Void)super.visitCompoundAssignment(node, state);
        }

        private boolean handleAssignment(ExpressionTree variable, VisitorState state) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)variable);
            if (symbol != null && symbol.isStatic() && symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                if (ClassInitializationDeadlock.isSubtype(varSymbol.owner.type, this.baseType, state)) {
                    state.reportMatch(ClassInitializationDeadlock.this.describeMatch(variable));
                    return true;
                }
            }
            return false;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, VisitorState state) {
            Symbol.VarSymbol varSymbol;
            Symbol symbol = ASTHelpers.getSymbol((Tree)node);
            if (symbol != null && symbol.isStatic() && symbol instanceof Symbol.VarSymbol && (varSymbol = (Symbol.VarSymbol)symbol).getConstValue() == null && ClassInitializationDeadlock.isSubtype(varSymbol.owner.type, this.baseType, state) && !varSymbol.name.contentEquals("class")) {
                state.reportMatch(ClassInitializationDeadlock.this.describeMatch(node));
                return null;
            }
            return (Void)super.visitMemberSelect(node, state);
        }

        @Override
        public Void visitClass(ClassTree _node, VisitorState _state) {
            return null;
        }

        @Override
        public Void visitMethod(MethodTree _node, VisitorState _state) {
            return null;
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree _node, VisitorState _state) {
            return null;
        }
    }
}

