/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@BugPattern(name="ReverseDnsLookup", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Calling address.getHostName may result in a reverse DNS lookup which is a network request, making the invocation significantly more expensive than expected depending on the environment.\nThis check is intended to be advisory - it's fine to @SuppressWarnings(\"ReverseDnsLookup\") in certain cases, but is usually not recommended.")
public final class ReverseDnsLookup
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> INET_SOCKET_ADDRESS_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(InetSocketAddress.class.getName()).named("getHostName");
    private static final Matcher<ExpressionTree> INET_ADDRESS_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(InetAddress.class.getName()).namedAnyOf(new String[]{"getHostName", "getCanonicalHostName"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (INET_SOCKET_ADDRESS_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getHostString", (VisitorState)state)).build();
        }
        if (INET_ADDRESS_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getHostAddress", (VisitorState)state)).build();
        }
        return Description.NO_MATCH;
    }
}

