/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(name="RedundantMethodReference", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Redundant method reference to the same type")
public final class RedundantMethodReference
extends BugChecker
implements BugChecker.MemberReferenceTreeMatcher {
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (tree.getMode() != MemberReferenceTree.ReferenceMode.INVOKE) {
            return Description.NO_MATCH;
        }
        if (!(tree instanceof JCTree.JCMemberReference)) {
            return Description.NO_MATCH;
        }
        JCTree.JCMemberReference jcMemberReference = (JCTree.JCMemberReference)tree;
        if (jcMemberReference.kind != JCTree.JCMemberReference.ReferenceKind.BOUND) {
            return Description.NO_MATCH;
        }
        Type rawResultType = ASTHelpers.getResultType((ExpressionTree)tree.getQualifierExpression());
        if (rawResultType == null) {
            return Description.NO_MATCH;
        }
        Type treeType = ASTHelpers.getType((Tree)tree);
        if (treeType == null) {
            return Description.NO_MATCH;
        }
        if (!state.getTypes().isAssignable(rawResultType, treeType)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        if (methodSymbol == null) {
            return Description.NO_MATCH;
        }
        Set matching = ASTHelpers.findMatchingMethods((Name)methodSymbol.name, symbol -> symbol.getModifiers().contains((Object)Modifier.ABSTRACT) && methodSymbol.overrides((Symbol)symbol, symbol.enclClass(), state.getTypes(), true), (Type)treeType, (Types)state.getTypes());
        if (matching.size() != 1) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().replace((Tree)tree, state.getSourceForNode((Tree)tree.getQualifierExpression())).build()).build();
    }
}

