/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="PreferStaticLoggers", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer static logger instances over instances to reduce object initialization costs and heap overhead. Some logger frameworks may run expensive classloader lookups when loggers are requested based on configuration.")
public final class PreferStaticLoggers
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<Tree> IS_LOGGER = Matchers.isSubtypeOf((String)"org.slf4j.Logger");
    private static final Matcher<ExpressionTree> LOGGER_FACTORY = MethodMatchers.staticMethod().onClass("org.slf4j.LoggerFactory").named("getLogger").withParameters(new String[]{"java.lang.Class"});
    private static final Matcher<ExpressionTree> GET_CLASS = MethodMatchers.instanceMethod().anyClass().named("getClass").withParameters(new String[0]);
    private static final Matcher<VariableTree> IS_FIELD = Matchers.isField();

    public Description matchVariable(VariableTree tree, VisitorState state) {
        MethodInvocationTree invocation;
        ExpressionTree argument;
        ExpressionTree initializer = tree.getInitializer();
        if (initializer == null) {
            return Description.NO_MATCH;
        }
        if (!IS_FIELD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (!IS_LOGGER.matches(tree.getType(), state)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol.isStatic()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        if (LOGGER_FACTORY.matches((Tree)initializer, state) && ASTHelpers.getReceiver((ExpressionTree)(argument = (invocation = (MethodInvocationTree)initializer).getArguments().get(0))) == null && GET_CLASS.matches((Tree)argument, state)) {
            fix.replace((Tree)argument, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)(ASTHelpers.enclosingClass((Symbol)symbol) + ".class")));
        }
        return this.buildDescription(tree).addFix((Fix)fix.build()).build();
    }
}

