/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="PreferCollectionTransform", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer Guava's Lists.transform or Collections2.transform instead of Iterables.transform when first argument's declared type is a List or Collection type for performance reasons, cf. https://google.github.io/guava/releases/23.0/api/docs/com/google/common/collect/Iterables.html#transform-java.lang.Iterable-com.google.common.base.Function-")
public final class PreferCollectionTransform
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> ITERABLES_TRANSFORM_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.collect.Iterables").named("transform");
    private static final Matcher<Tree> LIST_MATCHER = MoreMatchers.isSubtypeOf("java.util.List");
    private static final Matcher<Tree> COLLECTION_MATCHER = MoreMatchers.isSubtypeOf("java.util.Collection");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> args;
        if (ITERABLES_TRANSFORM_MATCHER.matches((Tree)tree, state) && (args = tree.getArguments()).size() > 1 && COLLECTION_MATCHER.matches((Tree)args.get(0), state)) {
            String errorMessage;
            String qualifiedType;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (LIST_MATCHER.matches((Tree)args.get(0), state)) {
                qualifiedType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.common.collect.Lists");
                errorMessage = "Prefer Lists.transform";
            } else {
                qualifiedType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.common.collect.Collections2");
                errorMessage = "Prefer Collections2.transform";
            }
            String method = qualifiedType + ".transform";
            return this.buildDescription(tree).setMessage(errorMessage).addFix((Fix)fix.replace((Tree)tree.getMethodSelect(), method).build()).build();
        }
        return Description.NO_MATCH;
    }
}

