/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="PreferBuiltInConcurrentKeySet", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer Java's built-in Concurrent Set implementation over Guava's ConcurrentHashSet, as it does the same thing with less indirection and doesn't rely on Guava")
public final class PreferBuiltInConcurrentKeySet
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.collect.Sets").named("newConcurrentHashSet").withParameters(new String[0]);
    private static final String ERROR_MESSAGE = "Prefer Java's built-in Concurrent Set implementation over Guava's ConcurrentHashSet, as it does same thing with less indirection and doesn't rely on Guava";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (MATCHER.matches((Tree)tree, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String qualifiedType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"java.util.concurrent.ConcurrentHashMap");
            return this.buildDescription(tree).setMessage(ERROR_MESSAGE).addFix((Fix)fix.replace((Tree)tree.getMethodSelect(), qualifiedType + ".newKeySet").build()).build();
        }
        return Description.NO_MATCH;
    }
}

