/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.common.reflect.AbstractInvocationHandler;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@BugPattern(name="InvocationHandlerDelegation", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="InvocationHandlers which delegate to another object must catch and unwrap InvocationTargetException, otherwise an UndeclaredThrowableException will be thrown each time the delegate throws an exception.\nThis check is intended to be advisory. It's fine to @SuppressWarnings(\"InvocationHandlerDelegation\") in certain cases, but is usually not recommended.")
public final class InvocationHandlerDelegation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodTree> INVOCATION_HANDLER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.isStatic()), MoreMatchers.hasSignature("invoke(java.lang.Object,java.lang.reflect.Method,java.lang.Object[])"), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)InvocationHandler.class.getName()))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.isStatic()), MoreMatchers.hasSignature("handleInvocation(java.lang.Object,java.lang.reflect.Method,java.lang.Object[])"), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)AbstractInvocationHandler.class.getName()))})});
    private static final Matcher<ExpressionTree> METHOD_INVOKE = MethodMatchers.instanceMethod().onExactClass(Method.class.getName()).withSignature("invoke(java.lang.Object,java.lang.Object...)");
    private static final Matcher<ExpressionTree> METHOD_INVOKE_ENCLOSED_BY_INVOCATION_HANDLER = Matchers.allOf((Matcher[])new Matcher[]{METHOD_INVOKE, Matchers.enclosingMethod(INVOCATION_HANDLER)});
    private static final Matcher<Tree> CONTAINS_METHOD_INVOKE = Matchers.contains(ExpressionTree.class, METHOD_INVOKE);
    private static final Matcher<ExpressionTree> UNWRAP_THROWABLE = MethodMatchers.instanceMethod().onDescendantOf(Throwable.class.getName()).named("getCause").withParameters(new String[0]);
    private static final Matcher<Tree> CONTAINS_UNWRAP_THROWABLE = Matchers.contains(ExpressionTree.class, UNWRAP_THROWABLE);
    private static final Matcher<ExpressionTree> UNWRAP_ITE = MethodMatchers.instanceMethod().onDescendantOf(InvocationTargetException.class.getName()).namedAnyOf(new String[]{"getCause", "getTargetException"}).withParameters(new String[0]);
    private static final Matcher<ExpressionTree> PASS_ITE = Matchers.methodInvocation((Matcher)Matchers.anyMethod(), (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isSubtypeOf(InvocationTargetException.class));
    private static final Matcher<Tree> CONTAINS_INSTANCEOF_ITE = Matchers.contains(InstanceOfTree.class, (Matcher & Serializable)(instanceOfTree, state) -> ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)instanceOfTree.getType()), (Type)state.getTypeFromString(InvocationTargetException.class.getName()), (VisitorState)state));
    private static final Matcher<Tree> CONTAINS_UNWRAP_ITE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.contains(ExpressionTree.class, UNWRAP_ITE), Matchers.contains(ExpressionTree.class, PASS_ITE), Matchers.contains(IfTree.class, (Matcher & Serializable)(ifExpression, state) -> CONTAINS_INSTANCEOF_ITE.matches((Tree)ifExpression.getCondition(), state) && CONTAINS_UNWRAP_THROWABLE.matches((Tree)ifExpression.getThenStatement(), state)), Matchers.contains(ConditionalExpressionTree.class, (Matcher & Serializable)(ifExpression, state) -> CONTAINS_INSTANCEOF_ITE.matches((Tree)ifExpression.getCondition(), state) && CONTAINS_UNWRAP_THROWABLE.matches((Tree)ifExpression.getTrueExpression(), state))});
    private static final Matcher<MethodTree> HANDLES_ITE;
    private static final Matcher<MethodInvocationTree> MATCHER;

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    static {
        Matcher[] matcherArray = new Matcher[3];
        matcherArray[0] = Matchers.contains(TryTree.class, (Matcher & Serializable)(tree, state) -> CONTAINS_METHOD_INVOKE.matches((Tree)tree.getBlock(), state) && tree.getCatches().stream().anyMatch(catchTree -> CONTAINS_UNWRAP_ITE.matches((Tree)catchTree.getBlock(), state)));
        matcherArray[1] = Matchers.contains(LambdaExpressionTree.class, (arg_0, arg_1) -> CONTAINS_METHOD_INVOKE.matches(arg_0, arg_1));
        matcherArray[2] = Matchers.contains(NewClassTree.class, (arg_0, arg_1) -> CONTAINS_METHOD_INVOKE.matches(arg_0, arg_1));
        HANDLES_ITE = Matchers.anyOf((Matcher[])matcherArray);
        MATCHER = Matchers.allOf((Matcher[])new Matcher[]{METHOD_INVOKE_ENCLOSED_BY_INVOCATION_HANDLER, Matchers.not((Matcher)Matchers.enclosingMethod(HANDLES_ITE))});
    }
}

