/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@BugPattern(name="DangerousParallelStreamUsage", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Discourage usage of .parallel() in Java streams.")
public final class DangerousParallelStreamUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String MORE_STREAMS_URL = "https://github.com/palantir/streams/blob/1.9.1/src/main/java/com/palantir/common/streams/MoreStreams.java#L53";
    private static final String ERROR_MESSAGE = "Should not use parallel Java streams. Doing so has very subtle and potentially severe performance implications, so in general you're better off using https://github.com/palantir/streams/blob/1.9.1/src/main/java/com/palantir/common/streams/MoreStreams.java#L53 which allows you to provide your own executor service and specify the desired parallelism (i.e. the max number of concurrent tasks that will be submitted).\nOn the contrary the implementation of Java parallel streams uses a globally shared ForkJoinPool and does not allow you to provide your own pool. Fork/join pools implement work-stealing, where any thread might steal a task from a different thread's queue when blocked waiting for a subtask to complete. This might not seem like an issue at first glance, but if you use .parallel() for short tasks extensively throughout your codebase and later on you add one piece of code that uses .parallel() for long (e.g. I/O) tasks, the other parts of your codebase that use .parallel(), and that you'd expect to have consistent performance, might experience performance degradation for no apparent reason. The reason is work stealing.\nYou can suppress this warning if you are certain that all your code will always only use .parallel() for short tasks, but even then, you have no real control over the level of parallelism, so you're still better off using MoreStreams (linked above)\nYou can find more info here: https://stackoverflow.com/a/54581148/7182570";
    private static final Matcher<ExpressionTree> PARALLEL_CALL_ON_JAVA_STREAM_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(Stream.class.getName()).named("parallel");
    private static final Matcher<ExpressionTree> PARALLEL_STREAM_ON_COLLECTION_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(Collection.class.getName()).named("parallelStream").withParameters(new String[0]);
    private static final Matcher<ExpressionTree> PARALLEL_STREAM_SUPPORT_MATCHER = Matchers.methodInvocation((Matcher)MethodMatchers.staticMethod().onClass(StreamSupport.class.getName()), (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.LAST, (Matcher)Matchers.booleanLiteral((boolean)true));
    private static final Matcher<ExpressionTree> PARALLEL_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{PARALLEL_CALL_ON_JAVA_STREAM_MATCHER, PARALLEL_STREAM_ON_COLLECTION_MATCHER, PARALLEL_STREAM_SUPPORT_MATCHER});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!PARALLEL_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(ERROR_MESSAGE).build();
    }
}

