/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.AnnotationHasArgumentWithValue;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.IsSameType;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.Serializable;

@BugPattern(name="DangerousJsonTypeInfoUsage", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Disallow usage of Jackson's JsonTypeInfo.Id.CLASS annotation for security reasons, cf. https://github.com/FasterXML/jackson-databind/issues/1599")
public final class DangerousJsonTypeInfoUsage
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<AnnotationTree> matcher = new AnnotationHasArgumentWithValue("use", Matchers.allOf((Matcher[])new Matcher[]{new IsSameType("com.fasterxml.jackson.annotation.JsonTypeInfo$Id"), Matchers.anyOf((Matcher[])new Matcher[]{DangerousJsonTypeInfoUsage.treeEqualsStringMatcher("JsonTypeInfo.Id.CLASS"), DangerousJsonTypeInfoUsage.treeEqualsStringMatcher("JsonTypeInfo.Id.MINIMAL_CLASS"), DangerousJsonTypeInfoUsage.treeEqualsStringMatcher("com.fasterxml.jackson.annotation.JsonTypeInfo.Id.CLASS"), DangerousJsonTypeInfoUsage.treeEqualsStringMatcher("com.fasterxml.jackson.annotation.JsonTypeInfo.Id.MINIMAL_CLASS")})}));

    private static Matcher<ExpressionTree> treeEqualsStringMatcher(String value) {
        return (Matcher & Serializable)(expressionTree, state) -> state.getSourceForNode(expressionTree).equals(value);
    }

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!matcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Must not use Jackson @JsonTypeInfo annotation with JsonTypeInfo.Id.CLASS or JsonTypeInfo.Id.MINIMAL_CLASS").build();
    }
}

