/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import java.util.Objects;
import netflix.nebula.dependency.recommender.RecommendationStrategy;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import org.gradle.api.Project;

public class RecommendationStrategyFactory {
    private final Project project;
    private RecommendationStrategy recommendationStrategy;

    public RecommendationStrategyFactory(Project project) {
        this.project = project;
    }

    public RecommendationStrategy getRecommendationStrategy() {
        if (this.recommendationStrategy == null) {
            try {
                RecommendationProviderContainer recommendationProviderContainer = (RecommendationProviderContainer)this.project.getExtensions().findByType(RecommendationProviderContainer.class);
                this.recommendationStrategy = Objects.requireNonNull(recommendationProviderContainer).getStrategy().getStrategyClass().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.recommendationStrategy;
    }
}

