/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExtendRecommenderConfigurationAction
implements Action<Configuration> {
    private Logger logger = Logging.getLogger(ExtendRecommenderConfigurationAction.class);
    private final Configuration bom;
    private final Project project;
    private final RecommendationProviderContainer container;

    public ExtendRecommenderConfigurationAction(Configuration bom, Project project, RecommendationProviderContainer container) {
        this.bom = bom;
        this.project = project;
        this.container = container;
    }

    public void execute(Configuration configuration) {
        if (!this.isClasspathConfiguration(configuration) || this.container.getExcludedConfigurations().contains(configuration.getName()) || this.isCopyOfBomConfiguration(configuration)) {
            return;
        }
        if (configuration.getState() == Configuration.State.UNRESOLVED) {
            Configuration toExtend = this.bom;
            if (!this.project.getRootProject().equals(this.project)) {
                toExtend = this.bom.copy();
                toExtend.setVisible(false);
                toExtend.setCanBeResolved(false);
                this.project.getConfigurations().add((Object)toExtend);
            }
            configuration.extendsFrom(new Configuration[]{toExtend});
        } else {
            this.logger.info("Configuration '" + configuration.getName() + "' has already been resolved and cannot be included for recommendation");
        }
    }

    private boolean isClasspathConfiguration(Configuration configuration) {
        return configuration.getName().endsWith("Classpath") || configuration.getName().toLowerCase().endsWith("annotationprocessor");
    }

    private boolean isCopyOfBomConfiguration(Configuration configuration) {
        return configuration.getName().startsWith(this.bom.getName());
    }
}

