/*
 * Decompiled with CFR 0.152.
 */
package com.leinardi.android.speeddial;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.MenuRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.PopupMenu;
import androidx.cardview.widget.CardView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.leinardi.android.speeddial.FabWithLabelView;
import com.leinardi.android.speeddial.R;
import com.leinardi.android.speeddial.SpeedDialActionItem;
import com.leinardi.android.speeddial.SpeedDialOverlayLayout;
import com.leinardi.android.speeddial.UiUtils;
import com.leinardi.android.speeddial.ViewGroupUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SpeedDialView
extends LinearLayout
implements CoordinatorLayout.AttachedBehavior {
    private static final String TAG = SpeedDialView.class.getSimpleName();
    private static final String STATE_KEY_SUPER = "superState";
    private static final String STATE_KEY_IS_OPEN = "isOpen";
    private static final String STATE_KEY_EXPANSION_MODE = "expansionMode";
    private static final int DEFAULT_ROTATE_ANGLE = 45;
    private static final int ACTION_ANIM_DELAY = 25;
    private static final int MAIN_FAB_HORIZONTAL_MARGIN_IN_DP = 4;
    private static final int MAIN_FAB_VERTICAL_MARGIN_IN_DP = -2;
    private final InstanceState mInstanceState = new InstanceState();
    private List<FabWithLabelView> mFabWithLabelViews = new ArrayList<FabWithLabelView>();
    @Nullable
    private Drawable mMainFabClosedDrawable = null;
    @Nullable
    private Drawable mMainFabOpenedDrawable = null;
    @Nullable
    private Drawable mMainFabCloseOriginalDrawable;
    private FloatingActionButton mMainFab;
    @IdRes
    private int mOverlayLayoutId;
    @Nullable
    private SpeedDialOverlayLayout mOverlayLayout;
    @Nullable
    private OnChangeListener mOnChangeListener;
    @Nullable
    private OnActionSelectedListener mOnActionSelectedListener;
    private OnActionSelectedListener mOnActionSelectedProxyListener = new OnActionSelectedListener(){

        @Override
        public boolean onActionSelected(SpeedDialActionItem actionItem) {
            if (SpeedDialView.this.mOnActionSelectedListener != null) {
                boolean consumed = SpeedDialView.this.mOnActionSelectedListener.onActionSelected(actionItem);
                if (!consumed) {
                    SpeedDialView.this.close(false);
                }
                return consumed;
            }
            return false;
        }
    };

    public SpeedDialView(Context context) {
        super(context);
        this.init(context, null);
    }

    public SpeedDialView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SpeedDialView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public boolean getUseReverseAnimationOnClose() {
        return this.mInstanceState.mUseReverseAnimationOnClose;
    }

    public void setUseReverseAnimationOnClose(boolean useReverseAnimation) {
        this.mInstanceState.mUseReverseAnimationOnClose = useReverseAnimation;
    }

    public int getExpansionMode() {
        return this.mInstanceState.mExpansionMode;
    }

    public void setExpansionMode(int expansionMode) {
        this.setExpansionMode(expansionMode, false);
    }

    private void setExpansionMode(int expansionMode, boolean force) {
        if (this.mInstanceState.mExpansionMode != expansionMode || force) {
            this.mInstanceState.mExpansionMode = expansionMode;
            switch (expansionMode) {
                case 0: 
                case 1: {
                    this.setOrientation(1);
                    for (FabWithLabelView fabWithLabelView : this.mFabWithLabelViews) {
                        fabWithLabelView.setOrientation(0);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.setOrientation(0);
                    for (FabWithLabelView fabWithLabelView : this.mFabWithLabelViews) {
                        fabWithLabelView.setOrientation(1);
                    }
                    break;
                }
            }
            this.close(false);
            ArrayList<SpeedDialActionItem> actionItems = this.getActionItems();
            this.clearActionItems();
            this.addAllActionItems(actionItems);
        }
    }

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
    }

    public void show() {
        this.show(null);
    }

    public void show(@Nullable FloatingActionButton.OnVisibilityChangedListener listener) {
        this.setVisibility(0);
        this.showFabWithWorkaround(this.mMainFab, listener);
    }

    private void showFabWithWorkaround(FloatingActionButton fab, final @Nullable FloatingActionButton.OnVisibilityChangedListener listener) {
        fab.show(new FloatingActionButton.OnVisibilityChangedListener(){

            public void onShown(FloatingActionButton fab) {
                try {
                    Field declaredField = fab.getClass().getDeclaredField("impl");
                    declaredField.setAccessible(true);
                    Object impl = declaredField.get(fab);
                    Class<?> implClass = Build.VERSION.SDK_INT >= 21 ? impl.getClass().getSuperclass() : impl.getClass();
                    Method scale = implClass.getDeclaredMethod("setImageMatrixScale", Float.TYPE);
                    scale.setAccessible(true);
                    scale.invoke(impl, Float.valueOf(1.0f));
                }
                catch (NoSuchMethodException e) {
                    Log.e((String)TAG, (String)"Method setImageMatrixScale not found", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)TAG, (String)"IllegalAccessException", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)TAG, (String)"InvocationTargetException", (Throwable)e);
                }
                catch (NoSuchFieldException e) {
                    Log.e((String)TAG, (String)"Field impl not found", (Throwable)e);
                }
                if (listener != null) {
                    listener.onShown(fab);
                }
            }

            public void onHidden(FloatingActionButton fab) {
                if (listener != null) {
                    listener.onHidden(fab);
                }
            }
        });
    }

    public void hide() {
        this.hide(null);
    }

    public void setContentDescription(CharSequence contentDescription) {
        FloatingActionButton mainFab = this.getMainFab();
        if (mainFab != null) {
            this.setContentDescription(contentDescription);
        }
    }

    public void hide(final @Nullable FloatingActionButton.OnVisibilityChangedListener listener) {
        if (this.isOpen()) {
            this.close();
            ViewCompat.animate((View)this.mMainFab).rotation(0.0f).setDuration(0L).start();
        }
        this.mMainFab.hide(new FloatingActionButton.OnVisibilityChangedListener(){

            public void onShown(FloatingActionButton fab) {
                super.onShown(fab);
                if (listener != null) {
                    listener.onShown(fab);
                }
            }

            public void onHidden(FloatingActionButton fab) {
                super.onHidden(fab);
                SpeedDialView.this.setVisibility(4);
                if (listener != null) {
                    listener.onHidden(fab);
                }
            }
        });
    }

    @Nullable
    public SpeedDialOverlayLayout getOverlayLayout() {
        return this.mOverlayLayout;
    }

    public void setOverlayLayout(@Nullable SpeedDialOverlayLayout overlayLayout) {
        if (this.mOverlayLayout != null) {
            this.setOnClickListener(null);
        }
        this.mOverlayLayout = overlayLayout;
        if (overlayLayout != null) {
            overlayLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SpeedDialView.this.close();
                }
            });
            this.showHideOverlay(this.isOpen(), false);
        }
    }

    public void inflate(@MenuRes int menuRes) {
        this.clearActionItems();
        PopupMenu popupMenu = new PopupMenu(this.getContext(), new View(this.getContext()));
        popupMenu.inflate(menuRes);
        Menu menu = popupMenu.getMenu();
        for (int i = 0; i < menu.size(); ++i) {
            MenuItem menuItem = menu.getItem(i);
            SpeedDialActionItem actionItem = new SpeedDialActionItem.Builder(menuItem.getItemId(), menuItem.getIcon()).setLabel(menuItem.getTitle() != null ? menuItem.getTitle().toString() : null).create();
            this.addActionItem(actionItem);
        }
    }

    public Collection<FabWithLabelView> addAllActionItems(Collection<SpeedDialActionItem> actionItemCollection) {
        ArrayList<FabWithLabelView> fabWithLabelViews = new ArrayList<FabWithLabelView>();
        for (SpeedDialActionItem speedDialActionItem : actionItemCollection) {
            fabWithLabelViews.add(this.addActionItem(speedDialActionItem));
        }
        return fabWithLabelViews;
    }

    @Nullable
    public FabWithLabelView addActionItem(SpeedDialActionItem speedDialActionItem) {
        return this.addActionItem(speedDialActionItem, this.mFabWithLabelViews.size());
    }

    @Nullable
    public FabWithLabelView addActionItem(SpeedDialActionItem actionItem, int position) {
        return this.addActionItem(actionItem, position, true);
    }

    @Nullable
    public FabWithLabelView addActionItem(SpeedDialActionItem actionItem, int position, boolean animate) {
        FabWithLabelView oldView = this.findFabWithLabelViewById(actionItem.getId());
        if (oldView != null) {
            return this.replaceActionItem(oldView.getSpeedDialActionItem(), actionItem);
        }
        FabWithLabelView newView = actionItem.createFabWithLabelView(this.getContext());
        newView.setOrientation(this.getOrientation() == 1 ? 0 : 1);
        newView.setOnActionSelectedListener(this.mOnActionSelectedProxyListener);
        int layoutPosition = this.getLayoutPosition(position);
        this.addView((View)newView, layoutPosition);
        this.mFabWithLabelViews.add(position, newView);
        if (this.isOpen()) {
            if (animate) {
                this.showWithAnimationFabWithLabelView(newView, 0);
            }
        } else {
            newView.setVisibility(8);
        }
        return newView;
    }

    @Nullable
    public SpeedDialActionItem removeActionItem(int position) {
        SpeedDialActionItem speedDialActionItem = this.mFabWithLabelViews.get(position).getSpeedDialActionItem();
        this.removeActionItem(speedDialActionItem);
        return speedDialActionItem;
    }

    public boolean removeActionItem(@Nullable SpeedDialActionItem actionItem) {
        return actionItem != null && this.removeActionItemById(actionItem.getId()) != null;
    }

    @Nullable
    public SpeedDialActionItem removeActionItemById(@IdRes int idRes) {
        return this.removeActionItem(this.findFabWithLabelViewById(idRes));
    }

    @Nullable
    public FabWithLabelView replaceActionItem(SpeedDialActionItem newActionItem, int position) {
        return this.replaceActionItem(this.mFabWithLabelViews.get(position).getSpeedDialActionItem(), newActionItem);
    }

    @Nullable
    public FabWithLabelView replaceActionItem(@Nullable SpeedDialActionItem oldSpeedDialActionItem, SpeedDialActionItem newSpeedDialActionItem) {
        if (oldSpeedDialActionItem == null) {
            return null;
        }
        FabWithLabelView oldView = this.findFabWithLabelViewById(oldSpeedDialActionItem.getId());
        if (oldView != null) {
            int index = this.mFabWithLabelViews.indexOf((Object)oldView);
            if (index < 0) {
                return null;
            }
            this.removeActionItem(this.findFabWithLabelViewById(newSpeedDialActionItem.getId()), null, false);
            this.removeActionItem(this.findFabWithLabelViewById(oldSpeedDialActionItem.getId()), null, false);
            return this.addActionItem(newSpeedDialActionItem, index, false);
        }
        return null;
    }

    public void clearActionItems() {
        Iterator<FabWithLabelView> it = this.mFabWithLabelViews.iterator();
        while (it.hasNext()) {
            FabWithLabelView fabWithLabelView = it.next();
            this.removeActionItem(fabWithLabelView, it, true);
        }
    }

    @NonNull
    public ArrayList<SpeedDialActionItem> getActionItems() {
        ArrayList<SpeedDialActionItem> speedDialActionItems = new ArrayList<SpeedDialActionItem>(this.mFabWithLabelViews.size());
        for (FabWithLabelView fabWithLabelView : this.mFabWithLabelViews) {
            speedDialActionItems.add(fabWithLabelView.getSpeedDialActionItem());
        }
        return speedDialActionItems;
    }

    @NonNull
    public CoordinatorLayout.Behavior getBehavior() {
        return new SnackbarBehavior();
    }

    public void setOnActionSelectedListener(@Nullable OnActionSelectedListener listener) {
        this.mOnActionSelectedListener = listener;
        for (int index = 0; index < this.mFabWithLabelViews.size(); ++index) {
            FabWithLabelView fabWithLabelView = this.mFabWithLabelViews.get(index);
            fabWithLabelView.setOnActionSelectedListener(this.mOnActionSelectedProxyListener);
        }
    }

    public void setOnChangeListener(@Nullable OnChangeListener onChangeListener) {
        this.mOnChangeListener = onChangeListener;
    }

    public void open() {
        this.toggle(true, true);
    }

    public void open(boolean animate) {
        this.toggle(true, animate);
    }

    public void close() {
        this.toggle(false, true);
    }

    public void close(boolean animate) {
        this.toggle(false, animate);
    }

    public void toggle() {
        this.toggle(!this.isOpen(), true);
    }

    public void toggle(boolean animate) {
        this.toggle(!this.isOpen(), animate);
    }

    public boolean isOpen() {
        return this.mInstanceState.mIsOpen;
    }

    public FloatingActionButton getMainFab() {
        return this.mMainFab;
    }

    public float getMainFabAnimationRotateAngle() {
        return this.mInstanceState.mMainFabAnimationRotateAngle;
    }

    public void setMainFabAnimationRotateAngle(float mainFabAnimationRotateAngle) {
        this.mInstanceState.mMainFabAnimationRotateAngle = mainFabAnimationRotateAngle;
        this.setMainFabOpenedDrawable(this.mMainFabCloseOriginalDrawable);
    }

    public void setMainFabClosedDrawable(@Nullable Drawable drawable) {
        this.mMainFabClosedDrawable = drawable;
        this.updateMainFabDrawable(false);
    }

    public void setMainFabOpenedDrawable(@Nullable Drawable drawable) {
        this.mMainFabCloseOriginalDrawable = drawable;
        this.mMainFabOpenedDrawable = this.mMainFabCloseOriginalDrawable == null ? null : UiUtils.getRotateDrawable(this.mMainFabCloseOriginalDrawable, -this.getMainFabAnimationRotateAngle());
        this.updateMainFabDrawable(false);
    }

    @ColorInt
    public int getMainFabClosedBackgroundColor() {
        return this.mInstanceState.mMainFabClosedBackgroundColor;
    }

    public void setMainFabClosedBackgroundColor(@ColorInt int mainFabClosedBackgroundColor) {
        this.mInstanceState.mMainFabClosedBackgroundColor = mainFabClosedBackgroundColor;
        this.updateMainFabBackgroundColor();
    }

    @ColorInt
    public int getMainFabOpenedBackgroundColor() {
        return this.mInstanceState.mMainFabOpenedBackgroundColor;
    }

    public void setMainFabOpenedBackgroundColor(@ColorInt int mainFabOpenedBackgroundColor) {
        this.mInstanceState.mMainFabOpenedBackgroundColor = mainFabOpenedBackgroundColor;
        this.updateMainFabBackgroundColor();
    }

    @ColorInt
    public int getMainFabClosedIconColor() {
        return this.mInstanceState.mMainFabClosedIconColor;
    }

    public void setMainFabClosedIconColor(@ColorInt int mainFabClosedIconColor) {
        this.mInstanceState.mMainFabClosedIconColor = mainFabClosedIconColor;
        this.updateMainFabIconColor();
    }

    @ColorInt
    public int getMainFabOpenedIconColor() {
        return this.mInstanceState.mMainFabOpenedIconColor;
    }

    public void setMainFabOpenedIconColor(@ColorInt int mainFabOpenedIconColor) {
        this.mInstanceState.mMainFabOpenedIconColor = mainFabOpenedIconColor;
        this.updateMainFabIconColor();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mOverlayLayout == null) {
            SpeedDialOverlayLayout overlayLayout = (SpeedDialOverlayLayout)this.getRootView().findViewById(this.mOverlayLayoutId);
            this.setOverlayLayout(overlayLayout);
        }
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        this.mInstanceState.mSpeedDialActionItems = this.getActionItems();
        bundle.putParcelable(InstanceState.class.getName(), (Parcelable)this.mInstanceState);
        bundle.putParcelable(STATE_KEY_SUPER, super.onSaveInstanceState());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            InstanceState instanceState = (InstanceState)bundle.getParcelable(InstanceState.class.getName());
            if (instanceState != null && instanceState.mSpeedDialActionItems != null && !instanceState.mSpeedDialActionItems.isEmpty()) {
                this.setUseReverseAnimationOnClose(instanceState.mUseReverseAnimationOnClose);
                this.setMainFabAnimationRotateAngle(instanceState.mMainFabAnimationRotateAngle);
                this.setMainFabOpenedBackgroundColor(instanceState.mMainFabOpenedBackgroundColor);
                this.setMainFabClosedBackgroundColor(instanceState.mMainFabClosedBackgroundColor);
                this.setMainFabOpenedIconColor(instanceState.mMainFabOpenedIconColor);
                this.setMainFabClosedIconColor(instanceState.mMainFabClosedIconColor);
                this.setExpansionMode(instanceState.mExpansionMode, true);
                this.addAllActionItems(instanceState.mSpeedDialActionItems);
                this.toggle(instanceState.mIsOpen, false);
            }
            state = bundle.getParcelable(STATE_KEY_SUPER);
        }
        super.onRestoreInstanceState(state);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getMainFab().setEnabled(enabled);
    }

    private int getLayoutPosition(int position) {
        if (this.getExpansionMode() == 0 || this.getExpansionMode() == 2) {
            return this.mFabWithLabelViews.size() - position;
        }
        return position + 1;
    }

    @Nullable
    private SpeedDialActionItem removeActionItem(@Nullable FabWithLabelView view, @Nullable Iterator<FabWithLabelView> it, boolean animate) {
        if (view != null) {
            SpeedDialActionItem speedDialActionItem = view.getSpeedDialActionItem();
            if (it != null) {
                it.remove();
            } else {
                this.mFabWithLabelViews.remove((Object)view);
            }
            if (this.isOpen()) {
                if (this.mFabWithLabelViews.isEmpty()) {
                    this.close();
                }
                if (animate) {
                    UiUtils.shrinkAnim((View)view, true);
                } else {
                    this.removeView((View)view);
                }
            } else {
                this.removeView((View)view);
            }
            return speedDialActionItem;
        }
        return null;
    }

    @Nullable
    private SpeedDialActionItem removeActionItem(@Nullable FabWithLabelView view) {
        return this.removeActionItem(view, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.mMainFab = this.createMainFab();
        this.addView((View)this.mMainFab);
        this.setClipChildren(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.getResources().getDimension(R.dimen.sd_close_elevation));
        }
        TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.SpeedDialView, 0, 0);
        try {
            int closeDrawableRes;
            this.setEnabled(styledAttrs.getBoolean(R.styleable.SpeedDialView_android_enabled, this.isEnabled()));
            this.setUseReverseAnimationOnClose(styledAttrs.getBoolean(R.styleable.SpeedDialView_sdUseReverseAnimationOnClose, this.getUseReverseAnimationOnClose()));
            this.setMainFabAnimationRotateAngle(styledAttrs.getFloat(R.styleable.SpeedDialView_sdMainFabAnimationRotateAngle, this.getMainFabAnimationRotateAngle()));
            int openDrawableRes = styledAttrs.getResourceId(R.styleable.SpeedDialView_sdMainFabClosedSrc, Integer.MIN_VALUE);
            if (openDrawableRes != Integer.MIN_VALUE) {
                this.setMainFabClosedDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)openDrawableRes));
            }
            if ((closeDrawableRes = styledAttrs.getResourceId(R.styleable.SpeedDialView_sdMainFabOpenedSrc, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                this.setMainFabOpenedDrawable(AppCompatResources.getDrawable((Context)context, (int)closeDrawableRes));
            }
            this.setExpansionMode(styledAttrs.getInt(R.styleable.SpeedDialView_sdExpansionMode, this.getExpansionMode()), true);
            this.setMainFabClosedBackgroundColor(styledAttrs.getColor(R.styleable.SpeedDialView_sdMainFabClosedBackgroundColor, this.getMainFabClosedBackgroundColor()));
            this.setMainFabOpenedBackgroundColor(styledAttrs.getColor(R.styleable.SpeedDialView_sdMainFabOpenedBackgroundColor, this.getMainFabOpenedBackgroundColor()));
            this.setMainFabClosedIconColor(styledAttrs.getColor(R.styleable.SpeedDialView_sdMainFabClosedIconColor, this.getMainFabClosedIconColor()));
            this.setMainFabOpenedIconColor(styledAttrs.getColor(R.styleable.SpeedDialView_sdMainFabOpenedIconColor, this.getMainFabOpenedIconColor()));
            this.mOverlayLayoutId = styledAttrs.getResourceId(R.styleable.SpeedDialView_sdOverlayLayout, Integer.MIN_VALUE);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failure setting FabWithLabelView icon", (Throwable)e);
        }
        finally {
            styledAttrs.recycle();
        }
    }

    private FloatingActionButton createMainFab() {
        FloatingActionButton floatingActionButton = new FloatingActionButton(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 0x800005;
        int marginHorizontal = UiUtils.dpToPx(this.getContext(), 4.0f);
        int marginVertical = UiUtils.dpToPx(this.getContext(), -2.0f);
        layoutParams.setMargins(marginHorizontal, marginVertical, marginHorizontal, marginVertical);
        floatingActionButton.setId(R.id.sd_main_fab);
        floatingActionButton.setUseCompatPadding(true);
        floatingActionButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        floatingActionButton.setClickable(true);
        floatingActionButton.setFocusable(true);
        floatingActionButton.setSize(0);
        floatingActionButton.setContentDescription(this.getContentDescription());
        floatingActionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SpeedDialView.this.isOpen()) {
                    if (SpeedDialView.this.mOnChangeListener == null || !SpeedDialView.this.mOnChangeListener.onMainActionSelected()) {
                        SpeedDialView.this.close();
                    }
                } else {
                    SpeedDialView.this.open();
                }
            }
        });
        return floatingActionButton;
    }

    private void toggle(boolean show, boolean animate) {
        if (show && this.mFabWithLabelViews.isEmpty()) {
            show = false;
            if (this.mOnChangeListener != null) {
                this.mOnChangeListener.onMainActionSelected();
            }
        }
        if (this.isOpen() == show) {
            return;
        }
        this.mInstanceState.mIsOpen = show;
        this.visibilitySetup(show, animate, this.mInstanceState.mUseReverseAnimationOnClose);
        this.updateMainFabDrawable(animate);
        this.updateMainFabBackgroundColor();
        this.updateMainFabIconColor();
        this.showHideOverlay(show, animate);
        if (this.mOnChangeListener != null) {
            this.mOnChangeListener.onToggleChanged(show);
        }
    }

    private void updateMainFabDrawable(boolean animate) {
        if (this.isOpen()) {
            if (this.mMainFabOpenedDrawable != null) {
                if (Build.VERSION.SDK_INT >= 24 && this.mMainFabOpenedDrawable instanceof AnimatedVectorDrawable) {
                    this.mMainFab.setImageDrawable(this.mMainFabOpenedDrawable);
                    ((AnimatedVectorDrawable)this.mMainFabOpenedDrawable).start();
                } else if (Build.VERSION.SDK_INT < 24 && this.mMainFabOpenedDrawable instanceof AnimatedVectorDrawableCompat) {
                    this.mMainFab.setImageDrawable(this.mMainFabOpenedDrawable);
                    ((AnimatedVectorDrawableCompat)this.mMainFabOpenedDrawable).start();
                } else if (this.mMainFabOpenedDrawable instanceof AnimationDrawable) {
                    this.mMainFab.setImageDrawable(this.mMainFabOpenedDrawable);
                    ((AnimationDrawable)this.mMainFabOpenedDrawable).start();
                } else {
                    Bitmap bitmap = UiUtils.getBitmapFromDrawable(this.mMainFabOpenedDrawable);
                    this.mMainFab.setImageBitmap(bitmap);
                }
            }
            UiUtils.rotateForward((View)this.mMainFab, this.getMainFabAnimationRotateAngle(), animate);
        } else {
            UiUtils.rotateBackward((View)this.mMainFab, animate);
            this.mMainFab.setImageDrawable(this.mMainFabClosedDrawable);
            if (this.mMainFabClosedDrawable != null) {
                if (Build.VERSION.SDK_INT >= 24 && this.mMainFabClosedDrawable instanceof AnimatedVectorDrawable) {
                    ((AnimatedVectorDrawable)this.mMainFabClosedDrawable).start();
                } else if (Build.VERSION.SDK_INT < 24 && this.mMainFabClosedDrawable instanceof AnimatedVectorDrawableCompat) {
                    ((AnimatedVectorDrawableCompat)this.mMainFabClosedDrawable).start();
                } else if (this.mMainFabClosedDrawable instanceof AnimationDrawable) {
                    ((AnimationDrawable)this.mMainFabClosedDrawable).start();
                }
            }
        }
    }

    private void updateMainFabBackgroundColor() {
        int color2 = this.isOpen() ? this.getMainFabOpenedBackgroundColor() : this.getMainFabClosedBackgroundColor();
        if (color2 != Integer.MIN_VALUE) {
            this.mMainFab.setBackgroundTintList(ColorStateList.valueOf((int)color2));
        } else {
            this.mMainFab.setBackgroundTintList(ColorStateList.valueOf((int)UiUtils.getAccentColor(this.getContext())));
        }
    }

    private void updateMainFabIconColor() {
        int color2 = this.isOpen() ? this.getMainFabOpenedIconColor() : this.getMainFabClosedIconColor();
        if (color2 != Integer.MIN_VALUE) {
            ImageViewCompat.setImageTintList((ImageView)this.mMainFab, (ColorStateList)ColorStateList.valueOf((int)color2));
        }
    }

    private void updateElevation() {
        if (this.isOpen()) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.setElevation(this.getResources().getDimension(R.dimen.sd_open_elevation));
            } else {
                this.bringToFront();
            }
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.getResources().getDimension(R.dimen.sd_close_elevation));
        }
    }

    private void showHideOverlay(boolean show, boolean animate) {
        if (this.mOverlayLayout != null) {
            if (show) {
                this.mOverlayLayout.show(animate);
            } else {
                this.mOverlayLayout.hide(animate);
            }
        }
    }

    @Nullable
    private FabWithLabelView findFabWithLabelViewById(@IdRes int id2) {
        for (FabWithLabelView fabWithLabelView : this.mFabWithLabelViews) {
            if (fabWithLabelView.getId() != id2) continue;
            return fabWithLabelView;
        }
        return null;
    }

    private void visibilitySetup(boolean visible, boolean animate, boolean reverseAnimation) {
        int size = this.mFabWithLabelViews.size();
        if (visible) {
            for (int i = 0; i < size; ++i) {
                FabWithLabelView fabWithLabelView = this.mFabWithLabelViews.get(i);
                fabWithLabelView.setAlpha(1.0f);
                fabWithLabelView.setVisibility(0);
                if (animate) {
                    this.showWithAnimationFabWithLabelView(fabWithLabelView, i * 25);
                }
                if (i == 0) {
                    fabWithLabelView.getFab().requestFocusFromTouch();
                }
                if (i != size - 1) continue;
                fabWithLabelView.getFab().setNextFocusUpId(fabWithLabelView.getFab().getId());
                this.getMainFab().setNextFocusDownId(this.getMainFab().getId());
                this.getMainFab().setNextFocusForwardId(this.getMainFab().getId());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int index = reverseAnimation ? size - 1 - i : i;
                FabWithLabelView fabWithLabelView = this.mFabWithLabelViews.get(index);
                if (animate) {
                    if (reverseAnimation) {
                        this.hideWithAnimationFabWithLabelView(fabWithLabelView, i * 25);
                        continue;
                    }
                    UiUtils.shrinkAnim((View)fabWithLabelView, false);
                    continue;
                }
                fabWithLabelView.setAlpha(0.0f);
                fabWithLabelView.setVisibility(8);
            }
        }
    }

    private void showWithAnimationFabWithLabelView(FabWithLabelView fabWithLabelView, int delay) {
        ViewCompat.animate((View)fabWithLabelView).cancel();
        UiUtils.enlargeAnim((View)fabWithLabelView.getFab(), delay);
        if (fabWithLabelView.isLabelEnabled()) {
            CardView labelBackground = fabWithLabelView.getLabelBackground();
            ViewCompat.animate((View)labelBackground).cancel();
            Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.sd_fade_and_translate_in);
            animation.setStartOffset((long)delay);
            labelBackground.startAnimation(animation);
        }
    }

    private void hideWithAnimationFabWithLabelView(FabWithLabelView fabWithLabelView, int delay) {
        ViewCompat.animate((View)fabWithLabelView).cancel();
        UiUtils.shrinkAnim((View)fabWithLabelView.getFab(), delay);
        if (fabWithLabelView.isLabelEnabled()) {
            final CardView labelBackground = fabWithLabelView.getLabelBackground();
            ViewCompat.animate((View)labelBackground).cancel();
            Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.sd_fade_and_translate_out);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    labelBackground.setVisibility(8);
                }

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            animation.setStartOffset((long)delay);
            labelBackground.startAnimation(animation);
        }
    }

    public static class NoBehavior
    extends CoordinatorLayout.Behavior<View> {
        public NoBehavior() {
        }

        public NoBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }
    }

    public static class ScrollingViewSnackbarBehavior
    extends SnackbarBehavior {
        private boolean mWasShownAlready = false;

        public ScrollingViewSnackbarBehavior() {
        }

        public ScrollingViewSnackbarBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
            return true;
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
            if (!this.mWasShownAlready && dependency instanceof RecyclerView && (((RecyclerView)dependency).getAdapter() == null || ((RecyclerView)dependency).getAdapter().getItemCount() == 0)) {
                this.show(child);
                this.mWasShownAlready = true;
            }
            return dependency instanceof RecyclerView || super.layoutDependsOn(parent, child, dependency);
        }

        public void onNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
            super.onNestedScroll(coordinatorLayout, child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type);
            this.mWasShownAlready = false;
            if (dyConsumed > 0 && child.getVisibility() == 0) {
                this.hide(child);
            } else if (dyConsumed < 0) {
                this.show(child);
            }
        }
    }

    public static class SnackbarBehavior
    extends CoordinatorLayout.Behavior<View> {
        private static final boolean AUTO_HIDE_DEFAULT = true;
        @Nullable
        private Rect mTmpRect;
        @Nullable
        private FloatingActionButton.OnVisibilityChangedListener mInternalAutoHideListener;
        private boolean mAutoHideEnabled;

        public SnackbarBehavior() {
            this.mAutoHideEnabled = true;
        }

        public SnackbarBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionButton_Behavior_Layout);
            this.mAutoHideEnabled = a.getBoolean(R.styleable.FloatingActionButton_Behavior_Layout_behavior_autoHide, true);
            a.recycle();
        }

        private static boolean isBottomSheet(@NonNull View view) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                return ((CoordinatorLayout.LayoutParams)lp).getBehavior() instanceof BottomSheetBehavior;
            }
            return false;
        }

        public boolean isAutoHideEnabled() {
            return this.mAutoHideEnabled;
        }

        public void setAutoHideEnabled(boolean autoHide) {
            this.mAutoHideEnabled = autoHide;
        }

        public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams lp) {
            if (lp.dodgeInsetEdges == 0) {
                lp.dodgeInsetEdges = 80;
            }
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
            if (dependency instanceof AppBarLayout) {
                this.updateFabVisibilityForAppBarLayout(parent, (AppBarLayout)dependency, child);
            } else if (SnackbarBehavior.isBottomSheet(dependency)) {
                this.updateFabVisibilityForBottomSheet(dependency, child);
            }
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout parent, View child, int layoutDirection) {
            View dependency;
            List dependencies = parent.getDependencies(child);
            int count = dependencies.size();
            for (int i = 0; i < count && !((dependency = (View)dependencies.get(i)) instanceof AppBarLayout ? this.updateFabVisibilityForAppBarLayout(parent, (AppBarLayout)dependency, child) : SnackbarBehavior.isBottomSheet(dependency) && this.updateFabVisibilityForBottomSheet(dependency, child)); ++i) {
            }
            parent.onLayoutChild(child, layoutDirection);
            return true;
        }

        @VisibleForTesting
        void setInternalAutoHideListener(@Nullable FloatingActionButton.OnVisibilityChangedListener listener) {
            this.mInternalAutoHideListener = listener;
        }

        protected void show(View child) {
            if (child instanceof FloatingActionButton) {
                ((FloatingActionButton)child).show(this.mInternalAutoHideListener);
            } else if (child instanceof SpeedDialView) {
                ((SpeedDialView)child).show(this.mInternalAutoHideListener);
            } else {
                child.setVisibility(0);
            }
        }

        protected void hide(View child) {
            if (child instanceof FloatingActionButton) {
                ((FloatingActionButton)child).hide(this.mInternalAutoHideListener);
            } else if (child instanceof SpeedDialView) {
                ((SpeedDialView)child).hide(this.mInternalAutoHideListener);
            } else {
                child.setVisibility(4);
            }
        }

        private boolean shouldUpdateVisibility(View dependency, View child) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (!this.mAutoHideEnabled) {
                return false;
            }
            if (lp.getAnchorId() != dependency.getId()) {
                return false;
            }
            return child.getVisibility() == 0;
        }

        private boolean updateFabVisibilityForAppBarLayout(CoordinatorLayout parent, AppBarLayout appBarLayout, View child) {
            if (!this.shouldUpdateVisibility((View)appBarLayout, child)) {
                return false;
            }
            if (this.mTmpRect == null) {
                this.mTmpRect = new Rect();
            }
            Rect rect = this.mTmpRect;
            ViewGroupUtils.getDescendantRect((ViewGroup)parent, (View)appBarLayout, rect);
            if (rect.bottom <= this.getMinimumHeightForVisibleOverlappingContent(appBarLayout)) {
                child.setVisibility(8);
            } else {
                child.setVisibility(0);
            }
            return true;
        }

        private int getMinimumHeightForVisibleOverlappingContent(AppBarLayout appBarLayout) {
            int minHeight = ViewCompat.getMinimumHeight((View)appBarLayout);
            if (minHeight != 0) {
                return minHeight * 2;
            }
            int childCount = appBarLayout.getChildCount();
            return childCount >= 1 ? ViewCompat.getMinimumHeight((View)appBarLayout.getChildAt(childCount - 1)) * 2 : 0;
        }

        private boolean updateFabVisibilityForBottomSheet(View bottomSheet, View child) {
            if (!this.shouldUpdateVisibility(bottomSheet, child)) {
                return false;
            }
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (bottomSheet.getTop() < child.getHeight() / 2 + lp.topMargin) {
                this.hide(child);
            } else {
                this.show(child);
            }
            return true;
        }
    }

    private static class InstanceState
    implements Parcelable {
        private boolean mIsOpen = false;
        @ColorInt
        private int mMainFabClosedBackgroundColor = Integer.MIN_VALUE;
        @ColorInt
        private int mMainFabOpenedBackgroundColor = Integer.MIN_VALUE;
        @ColorInt
        private int mMainFabClosedIconColor = Integer.MIN_VALUE;
        @ColorInt
        private int mMainFabOpenedIconColor = Integer.MIN_VALUE;
        private int mExpansionMode = 0;
        private float mMainFabAnimationRotateAngle = 45.0f;
        private boolean mUseReverseAnimationOnClose = false;
        private ArrayList<SpeedDialActionItem> mSpeedDialActionItems = new ArrayList();
        public static final Parcelable.Creator<InstanceState> CREATOR = new Parcelable.Creator<InstanceState>(){

            public InstanceState createFromParcel(Parcel source) {
                return new InstanceState(source);
            }

            public InstanceState[] newArray(int size) {
                return new InstanceState[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte(this.mIsOpen ? (byte)1 : 0);
            dest.writeInt(this.mMainFabClosedBackgroundColor);
            dest.writeInt(this.mMainFabOpenedBackgroundColor);
            dest.writeInt(this.mMainFabClosedIconColor);
            dest.writeInt(this.mMainFabOpenedIconColor);
            dest.writeInt(this.mExpansionMode);
            dest.writeFloat(this.mMainFabAnimationRotateAngle);
            dest.writeByte(this.mUseReverseAnimationOnClose ? (byte)1 : 0);
            dest.writeTypedList(this.mSpeedDialActionItems);
        }

        public InstanceState() {
        }

        protected InstanceState(Parcel in) {
            this.mIsOpen = in.readByte() != 0;
            this.mMainFabClosedBackgroundColor = in.readInt();
            this.mMainFabOpenedBackgroundColor = in.readInt();
            this.mMainFabClosedIconColor = in.readInt();
            this.mMainFabOpenedIconColor = in.readInt();
            this.mExpansionMode = in.readInt();
            this.mMainFabAnimationRotateAngle = in.readFloat();
            this.mUseReverseAnimationOnClose = in.readByte() != 0;
            this.mSpeedDialActionItems = in.createTypedArrayList(SpeedDialActionItem.CREATOR);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExpansionMode {
        public static final int TOP = 0;
        public static final int BOTTOM = 1;
        public static final int LEFT = 2;
        public static final int RIGHT = 3;
    }

    public static interface OnActionSelectedListener {
        public boolean onActionSelected(SpeedDialActionItem var1);
    }

    public static interface OnChangeListener {
        public boolean onMainActionSelected();

        public void onToggleChanged(boolean var1);
    }
}

