/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.signal._internals;

import android.support.annotation.NonNull;
import com.google.protobuf.ByteString;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.Objects;
import com.hummer.im._internals.chatsvc.ChatServiceImpl;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.proto.Push;
import com.hummer.im._internals.proto.Signal;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import com.hummer.im.model.signal.SendingOptions;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import com.hummer.im.signal.SignalService;
import com.hummer.im.signal._internals.rpc.RPCQueryUserState;
import com.hummer.im.signal._internals.rpc.RPCSendP2PSignalMessage;
import java.util.HashSet;

public class SignalServiceImpl
implements ServiceProvider.Service,
SignalService {
    private final HashSet<SignalService.Listener> mMessageListeners = new HashSet();
    private static final String IM_URI = "service_api_gateway/cim.proto.PushService.UnreliableIMPushMsg";
    private static final String TAG = "SignalService";

    private void registerChatServiceExtensions() {
        ChatServiceImpl.registerParserExtension((ChatServiceImpl.ParserExtension)new ChatServiceImpl.ParserExtension(){

            public String toString() {
                return "SignalServiceImpl";
            }

            public Message parseMessage(String string, String string2, byte[] byArray) {
                String string3 = string + '/' + string2;
                if (Objects.equals((Object)string3, (Object)SignalServiceImpl.IM_URI)) {
                    try {
                        Push.UnreliableIMPushMsgRequest unreliableIMPushMsgRequest = (Push.UnreliableIMPushMsgRequest)((Push.UnreliableIMPushMsgRequest.Builder)Push.UnreliableIMPushMsgRequest.newBuilder().mergeFrom(byArray)).build();
                        if (unreliableIMPushMsgRequest.getEnvName() != null && !unreliableIMPushMsgRequest.getEnvName().isEmpty()) {
                            HMRContext.Region region = HMRContext.Region.make((String)(unreliableIMPushMsgRequest.getRegion() + "/" + unreliableIMPushMsgRequest.getEnvType() + "/" + unreliableIMPushMsgRequest.getEnvName()));
                            String string4 = HMRContext.region.toString();
                            String string5 = region.toString();
                            if (!Objects.equals((Object)string5, (Object)string4)) {
                                Log.i((String)SignalServiceImpl.TAG, (Object)Trace.once().method("parseMessage").msg((Object)"Ignored parse of different env").info("localEnv", (Object)string4).info("remoteEnv", (Object)string5));
                                return null;
                            }
                        }
                        if (unreliableIMPushMsgRequest.getMsg().getAction() != Im.Action.kNotifySignalMessage) {
                            Log.i((String)SignalServiceImpl.TAG, (Object)Trace.once().method("parseMessage").msg((Object)"Unregonized action for unreliable message"));
                            return null;
                        }
                        SignalServiceImpl.this.parseSignalMessage(unreliableIMPushMsgRequest.getMsg().getContent(), unreliableIMPushMsgRequest.getMsg().getTimestamp());
                    }
                    catch (Throwable throwable) {
                        Log.e((String)SignalServiceImpl.TAG, (Object)Trace.once((Object)"Failed parsing UnreliableIMPushMsgRequest").info("Exception", (Object)throwable));
                    }
                }
                return null;
            }

            public Message parseMessage(Im.Msg msg, Source source) {
                try {
                    if (msg.getAction() == Im.Action.kNotifySignalMessage) {
                        SignalServiceImpl.this.parseSignalMessage(msg.getContent(), msg.getTimestamp(), source);
                    }
                }
                catch (Throwable throwable) {
                    Log.e((String)SignalServiceImpl.TAG, (Object)Trace.once().method("parse").info("action", (Object)msg.getAction()).info("msg", (Object)msg.getContent()).info("exception", (Object)throwable.getMessage()));
                }
                return null;
            }
        });
    }

    private void parseSignalMessage(ByteString byteString, long l, Source source) {
        if (source.getMode() instanceof Source.Shared) {
            return;
        }
        this.parseSignalMessage(byteString, l);
    }

    private void parseSignalMessage(ByteString byteString, long l) {
        Signal.SignalMessage signalMessage = (Signal.SignalMessage)((Signal.SignalMessage.Builder)Signal.SignalMessage.newBuilder().mergeFrom(byteString)).build();
        com.hummer.im.model.signal.Message message = new com.hummer.im.model.signal.Message(signalMessage.getType(), signalMessage.getContent().toByteArray());
        message.setServerAcceptedTs(l);
        message.setAppExtras(signalMessage.getExtensionsMap());
        this.notifyReceivedMessage(message, new User(signalMessage.getFromUid()));
    }

    @Override
    public void queryOnlineStatusForUser(@NonNull User user, @NonNull HMR.CompletionArg<Boolean> completionArg) {
        Log.i((String)TAG, (Object)Trace.once().method("queryOnlineStatusForUser").info("user", (Object)user.getId()));
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "SignalService::queryOnlineStatusForUser");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCQueryUserState(user, (RichCompletionArg<Boolean>)richCompletionArg));
    }

    @Override
    public void send(@NonNull com.hummer.im.model.signal.Message message, @NonNull User user, @NonNull SendingOptions sendingOptions, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "SignalService::sendMessage");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCSendP2PSignalMessage(message, sendingOptions, user, richCompletion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SignalService.Listener listener) {
        HashSet<SignalService.Listener> hashSet = this.mMessageListeners;
        synchronized (hashSet) {
            this.mMessageListeners.add(listener);
        }
        Log.i((String)TAG, (Object)Trace.once().method("addMessageListener").info("name", (Object)listener.getClass().getSimpleName()).info("size", (Object)this.mMessageListeners.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(SignalService.Listener listener) {
        HashSet<SignalService.Listener> hashSet = this.mMessageListeners;
        synchronized (hashSet) {
            this.mMessageListeners.remove(listener);
        }
        Log.i((String)TAG, (Object)Trace.once().method("removeMessageListener").info("name", (Object)listener.getClass().getSimpleName()).info("size", (Object)this.mMessageListeners.size()));
    }

    private void notifyReceivedMessage(final @NonNull com.hummer.im.model.signal.Message message, final @NonNull User user) {
        Log.i((String)TAG, (Object)Trace.once().method("notifyReceivedMessage").info("message.type", (Object)message.getType()).info("message.ts", (Object)message.getServerAcceptedTs()).info("fromUser", (Object)user.getId()));
        DispatchQueue.main.async("SignalService::notifyReceivedMessage", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet hashSet = SignalServiceImpl.this.mMessageListeners;
                synchronized (hashSet) {
                    HashSet hashSet2 = (HashSet)SignalServiceImpl.this.mMessageListeners.clone();
                    for (SignalService.Listener listener : hashSet2) {
                        listener.onReceivedMessage(message, user);
                    }
                }
            }
        });
    }

    public Class[] staticDependencies() {
        return new Class[0];
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{Channel.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    public void initService() {
        this.registerChatServiceExtensions();
        ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)new Source.Private("SignalService/P2P", MQService.FetchStrategy.IgnoreBefore, 300000L)));
    }

    public void openService(@NonNull RichCompletion richCompletion) {
        CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
    }

    public void closeService() {
    }
}

