/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.db._internals;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.db.DBService;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import junit.framework.Assert;

public final class DBServiceImpl
implements ServiceProvider.Service,
DBService,
DBService.DaoSet {
    private static final String TAG = "DBService";
    private static int DB_VERSION = 2;
    private XDBHelper dbHelper;
    private static final DispatchQueue dbQueue = new DispatchQueue((DispatchQueue.HandlerProvider)new DispatchQueue.WorkerHandler("hmr_db"));
    private static final Map<String, Dao> cachedDao = new HashMap<String, Dao>();

    public Class[] staticDependencies() {
        return null;
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class};
    }

    public Class[] plantingDynamicDependencies() {
        return null;
    }

    public void initService() {
    }

    public void openService(final @NonNull RichCompletion richCompletion) {
        HMRContext.work.async("openService::DBService", new Runnable(){

            @Override
            public void run() {
                if (!cachedDao.isEmpty()) {
                    Log.e((String)"DBServiceImpl", (Object)Trace.once().method("openService").info("\u8d44\u6e90\u6e05\u7406\u5f02\u5e38", null));
                }
                String string = String.format(Locale.US, "hmr_%d_%s_%s_%d.db", HMRContext.appId, HMRContext.region.type, HMRContext.region.name, HMR.getMe().getId());
                Log.i((String)DBServiceImpl.TAG, (Object)Trace.once().method("openService").info("VERSION", (Object)DB_VERSION).info("DB", (Object)string));
                DBServiceImpl.this.dbHelper = new XDBHelper(HMRContext.getAppContext(), string, DB_VERSION, richCompletion);
                DBServiceImpl.this.dbHelper.getWritableDatabase();
            }
        });
    }

    public void closeService() {
        cachedDao.clear();
        if (this.dbHelper != null) {
            this.dbHelper.close();
            this.dbHelper = null;
        }
    }

    @Override
    public <T> Dao<T, ?> create(DatabaseTableConfig<T> databaseTableConfig, Class<T> clazz) {
        String string = this.daoName(databaseTableConfig, clazz);
        Dao dao = cachedDao.get(string);
        if (dao == null) {
            DaoManager.clearDaoCache();
            dao = databaseTableConfig != null && databaseTableConfig.getTableName() != null ? DaoManager.createDao((ConnectionSource)this.dbHelper.getConnectionSource(), databaseTableConfig) : DaoManager.createDao((ConnectionSource)this.dbHelper.getConnectionSource(), clazz);
            DaoManager.clearDaoCache();
            if (dao == null) {
                Log.e((String)"DBServiceImpl", (Object)Trace.once().method("create").info("dao", null));
            }
            cachedDao.put(string, dao);
        }
        return dao;
    }

    @Override
    public <T> void remove(DatabaseTableConfig<T> databaseTableConfig, Class<T> clazz) {
        cachedDao.remove(this.daoName(databaseTableConfig, clazz));
    }

    private <T> String daoName(DatabaseTableConfig<T> databaseTableConfig, Class<T> clazz) {
        String string;
        if (databaseTableConfig != null && databaseTableConfig.getTableName() != null) {
            string = "table|" + databaseTableConfig.getTableName();
        } else {
            Assert.assertNotNull((String)"\u5982\u679c\u6ca1\u6709\u660e\u786e\u7684\u8868\u540d\uff0c\u5219\u5e94\u63d0\u4f9b\u53ef\u4ee5\u786e\u5b9a\u8868\u540d\u7684Bean\u7c7b\u578b", clazz);
            string = "model|" + clazz.getName();
        }
        return string;
    }

    @Override
    public <Act extends DBService.Action> void execute(@NonNull Act Act) {
        this.execute(Act, null);
    }

    @Override
    public <Act extends DBService.Action> void execute(final @NonNull Act Act, final @Nullable RichCompletion richCompletion) {
        dbQueue.async(Act.toString(), new Runnable(){

            @Override
            public void run() {
                try {
                    Log.i((String)DBServiceImpl.TAG, (Object)Trace.once().method("execute").msg((Object)Act));
                    Act.process(DBServiceImpl.this.dbHelper, DBServiceImpl.this);
                    CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
                }
                catch (DBService.BreakByGuard breakByGuard) {
                    if (breakByGuard.err == null) {
                        CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
                    } else {
                        CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)breakByGuard.err);
                    }
                }
                catch (SQLException sQLException) {
                    Error error = new Error(1003, "\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38", (Object)sQLException);
                    Log.e((String)DBServiceImpl.TAG, (Error)error, (Object)Trace.once().method("execute").msg((Object)sQLException.getCause().toString()));
                    CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)error);
                }
                catch (Throwable throwable) {
                    Error error = HMR.getMe() == null ? new Error(1011, "Missing login user") : new Error(-1, "Unknown exception: " + throwable.getLocalizedMessage());
                    CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)error);
                }
            }
        });
    }

    @Override
    public int getOldVersion() {
        return this.dbHelper.oldVersion;
    }

    @Override
    public int getNewVersion() {
        return this.dbHelper.newVersion;
    }

    private static class XDBHelper
    extends OrmLiteSqliteOpenHelper {
        private final WeakReference<RichCompletion> completion;
        protected int oldVersion;
        protected int newVersion;

        XDBHelper(Context context, String string, int n, RichCompletion richCompletion) {
            super(context, string, null, n);
            this.completion = new WeakReference<RichCompletion>(richCompletion);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase, ConnectionSource connectionSource) {
            Log.i((String)DBServiceImpl.TAG, (Object)Trace.once().method("onCreate"));
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, ConnectionSource connectionSource, int n, int n2) {
            Log.i((String)DBServiceImpl.TAG, (Object)Trace.once().method("onUpgrade"));
            this.oldVersion = n;
            this.newVersion = n2;
        }

        public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            Log.i((String)DBServiceImpl.TAG, (Object)Trace.once().method("onDowngrade").info("oldVersion", (Object)n).info("newVersion", (Object)n2));
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            Log.i((String)DBServiceImpl.TAG, (Object)Trace.once().method("onOpen").info("isOpen", (Object)sQLiteDatabase.isOpen()).info("readonly", (Object)sQLiteDatabase.isReadOnly()));
            if (sQLiteDatabase.isOpen() && !sQLiteDatabase.isReadOnly()) {
                CompletionUtils.dispatchSuccess((RichCompletion)((RichCompletion)this.completion.get()));
            } else {
                CompletionUtils.dispatchFailure((RichCompletion)((RichCompletion)this.completion.get()), (Error)new Error(1003, "Couldn't open database"));
            }
        }
    }
}

