/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Im;
import com.hummer.im.model.chat.Content;

public final class Text
extends Content {
    private String text;

    public Text(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "Text{" + this.getText() + "}";
    }

    public static void registerCodecs() {
        Text.registerCodec(new Content.Codec(){

            @Override
            public int type() {
                return 0;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Text.class;
            }

            @Override
            public Content makeChatContent(byte[] byArray) {
                Im.TextMsg textMsg = (Im.TextMsg)((Im.TextMsg.Builder)Im.TextMsg.newBuilder().mergeFrom(byArray)).build();
                return new Text(textMsg.getText());
            }

            @Override
            public Content makeChatContent(String string) {
                return new Text(string);
            }

            @Override
            public byte[] makePBBytes(Content content) {
                Text text = (Text)content;
                Im.TextMsg textMsg = (Im.TextMsg)Im.TextMsg.newBuilder().setText(text.getText()).build();
                return textMsg.toByteArray();
            }

            @Override
            public String makeDBString(Content content) {
                if (!(content instanceof Text)) {
                    Log.e("Text", Trace.once().method("makeDBString").info("content", content));
                    return null;
                }
                return ((Text)content).getText();
            }

            public String toString() {
                return "TextCodec";
            }
        });
    }
}

