/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import android.media.MediaMetadataRetriever;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Patterns;
import android.webkit.URLUtil;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.services.upload.Uploader;
import com.hummer.im._internals.shared.FileUtils;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.service.UploadService;
import java.util.Locale;
import org.json.JSONObject;

public final class Audio
extends Content
implements Content.Preparable {
    public String url;
    public int duration;
    private static final String TAG = "Audio";

    public static Audio create(@NonNull String string) {
        if (!FileUtils.exists(string)) {
            Log.w(TAG, Trace.once().method("create").msg("File not exists").info("path", string));
            return null;
        }
        int n = 0;
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string);
        String string2 = mediaMetadataRetriever.extractMetadata(9);
        mediaMetadataRetriever.release();
        if (string2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
            n = Integer.parseInt(string2);
        }
        if (n == 0) {
            return null;
        }
        return new Audio(string, n);
    }

    public static void registerCodecs() {
        Audio.registerCodec(new Content.Codec(){
            private static final String KeyUrl = "url";
            private static final String KeyDuration = "dur";

            @Override
            public int type() {
                return 3;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Audio.class;
            }

            @Override
            public byte[] makePBBytes(Content content) {
                Audio audio = (Audio)content;
                Im.AudioMsg.Builder builder = Im.AudioMsg.newBuilder();
                builder.setUrl(audio.url);
                builder.setDuration(audio.duration);
                return ((Im.AudioMsg)builder.build()).toByteArray();
            }

            @Override
            public Content makeChatContent(byte[] byArray) {
                Im.AudioMsg audioMsg = (Im.AudioMsg)((Im.AudioMsg.Builder)Im.AudioMsg.newBuilder().mergeFrom(byArray)).build();
                return new Audio(audioMsg.getUrl(), audioMsg.getDuration());
            }

            @Override
            public String makeDBString(Content content) {
                Audio audio = (Audio)content;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(KeyUrl, (Object)audio.url);
                jSONObject.put(KeyDuration, audio.duration);
                return jSONObject.toString();
            }

            @Override
            public Content makeChatContent(String string) {
                JSONObject jSONObject = new JSONObject(string);
                return new Audio(jSONObject.getString(KeyUrl), jSONObject.getInt(KeyDuration));
            }

            public String toString() {
                return "AudioCodec";
            }
        });
    }

    public String toString() {
        return String.format(Locale.US, "Audio{%dms, %s}", this.duration, this.url);
    }

    @Override
    public void prepare(final Content.PreparingCallback preparingCallback) {
        if (this.url.isEmpty()) {
            Log.e(TAG, Trace.once().method("prepare").info("url", this.url));
            preparingCallback.onPrepareFailed(new Error(1002, "Invalid url."));
            return;
        }
        if (Patterns.WEB_URL.matcher(this.url).matches() || URLUtil.isValidUrl((String)this.url)) {
            preparingCallback.onPrepareSuccess();
            return;
        }
        HMR.getService(UploadService.class).uploadFile(this.url, new Uploader.UploadCallback<String>(){

            @Override
            public void onSuccess(String string) {
                Audio.this.url = string;
                preparingCallback.onPrepareSuccess();
            }

            @Override
            public void onProgress(float f) {
                preparingCallback.onPrepare(new Preparing.ScalarProgress(f));
            }

            @Override
            public void onFailure(Error error) {
                preparingCallback.onPrepareFailed(error);
            }
        });
    }

    private Audio(@NonNull String string, Integer n) {
        this.url = string;
        this.duration = n;
    }
}

