/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat;

import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im.model.chat.states.Preparing;

public class Content {
    public static final int CustomTypeStart = 10000;
    private static final PBCodecs pbCodecs = new PBCodecs();
    private static final DBCodecs dbCodecs = new DBCodecs();

    public static Integer getDataType(Content content) {
        return (Integer)pbCodecs.getDataType(content);
    }

    public static byte[] makeBytes(Content content) {
        return (byte[])pbCodecs.encode(content);
    }

    public static String makeString(Content content) {
        return (String)dbCodecs.encode(content);
    }

    public static Content makeContent(int n, byte[] byArray) {
        return (Content)pbCodecs.decode(n, byArray);
    }

    public static Content makeContent(int n, String string) {
        return (Content)dbCodecs.decode(n, string);
    }

    protected static void registerCodec(final Codec codec) {
        Log.i("Content", Trace.once("registerCodec").info("type", codec.type()).info("codec", codec));
        pbCodecs.register(new CodecManager.Codec<Integer, byte[], Content>(){

            @Override
            public Integer getDataType() {
                return codec.type();
            }

            @Override
            public Class<? extends Content> getModelClass() {
                return codec.contentClass();
            }

            @Override
            public byte[] encode(Content content) {
                return codec.makePBBytes(content);
            }

            @Override
            public Content decode(byte[] byArray) {
                return codec.makeChatContent(byArray);
            }
        });
        dbCodecs.register(new CodecManager.Codec<Integer, String, Content>(){

            @Override
            public Integer getDataType() {
                return codec.type();
            }

            @Override
            public Class<? extends Content> getModelClass() {
                return codec.contentClass();
            }

            @Override
            public String encode(Content content) {
                return codec.makeDBString(content);
            }

            @Override
            public Content decode(String string) {
                return codec.makeChatContent(string);
            }
        });
    }

    private static final class DBCodecs
    extends CodecManager<Integer, String, Content> {
        private DBCodecs() {
        }
    }

    private static final class PBCodecs
    extends CodecManager<Integer, byte[], Content> {
        private PBCodecs() {
        }
    }

    public static interface Codec {
        public int type();

        public Class<? extends Content> contentClass();

        public byte[] makePBBytes(Content var1);

        public Content makeChatContent(byte[] var1);

        public String makeDBString(Content var1);

        public Content makeChatContent(String var1);
    }

    public static interface PreparingCallback {
        public void onPrepare(Preparing.Progress var1);

        public void onPrepareSuccess();

        public void onPrepareFailed(Error var1);
    }

    public static interface Preparable {
        public void prepare(PreparingCallback var1);
    }
}

