/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.yyp;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Receiver;
import com.hummer.im._internals.yyp.packet.Sender;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im.service.Channel;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Locale;

public abstract class ChatRoomRPC<Response extends Marshallable>
implements Channel.RPC {
    private long startTs;
    private Trace.Flow flow = new Trace.Flow();
    private static final String TAG = "ChatRoomRPC";

    public abstract Marshallable requestObj();

    public abstract void handleSuccess(@NonNull Response var1);

    public abstract String getChatroomServiceName();

    @Override
    public String protoType() {
        return null;
    }

    @Override
    public byte[] getRequestBytes() {
        Sender sender = new Sender(this.requestObj());
        sender.endPack();
        this.startTs = System.currentTimeMillis();
        Log.i(TAG, this.flow.trace().method(this.getFunctionName()).msg("-> {" + this.requestObj().toString() + "}"));
        return sender.getBytes();
    }

    @Override
    public void handleResponse(@NonNull byte[] byArray) {
        Field field;
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Marshallable marshallable = (Marshallable)clazz.newInstance();
        Receiver receiver = new Receiver(byArray);
        receiver.unmarshallWrap2(marshallable);
        try {
            field = marshallable.getClass().getDeclaredField("res");
        }
        catch (Exception exception) {
            field = marshallable.getClass().getDeclaredField("rescode");
        }
        if (field == null) {
            Log.e(TAG, Trace.once().method("handleResponse").msg("resCodeField is <null>"));
        }
        int n = ((Uint32)field.get(marshallable)).intValue();
        Log.i(TAG, Trace.once().method("ChatRoomRPC.handleResponse").info("code", n).info("resCls", marshallable.getClass().getSimpleName()));
        long l = System.currentTimeMillis() - this.startTs;
        if (n == 0) {
            this.handleSuccess(marshallable);
            Log.i(TAG, this.flow.trace().method(this.getFunctionName()).msg("<- Succeed {" + marshallable.toString() + "}"));
        } else {
            Field field2 = marshallable.getClass().getDeclaredField("msg");
            String string = "service error";
            if (field2 != null) {
                string = field2.get(marshallable) == null ? string : (String)field2.get(marshallable);
            }
            Error error = new Error(n, string);
            this.handleError(marshallable, error);
            Log.e(TAG, error, this.flow.trace().method(this.getFunctionName()).msg("<- Failed {" + new StringChain().add("logId", this.flow.logId).add("response", marshallable.toString()).add("msg", string).toString() + "}"));
        }
        HiidoReporter.reportReturnCodeTemporary(this.getFunctionName(), l, n);
    }

    @Override
    public String serviceName() {
        if (TextUtils.isEmpty((CharSequence)HMRContext.chatRoomRegion)) {
            HMRContext.chatRoomRegion = "chn";
        }
        return String.format(Locale.US, "svc_%s_%s", HMRContext.chatRoomRegion, this.getChatroomServiceName());
    }

    public void handleError(@Nullable Response Response, @NonNull Error error) {
        this.handleError(error);
    }
}

