/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.statis.IStatisHttpUtil;
import com.hummer.im._internals.shared.statis.MetricsCount;
import com.hummer.im._internals.shared.statis.MetricsPkg;
import com.hummer.im._internals.shared.statis.MetricsResult;
import com.hummer.im._internals.shared.statis.StatisContent;
import com.hummer.im._internals.shared.statis.Util;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetricsWorker {
    public static final String ACT = "mmetric";
    private static final String TAG = "MetricsWorker";
    private int maxCount = 10;
    private IStatisHttpUtil mMetircs;
    private IStatisHttpUtil mHiido;
    private MetricsPkg pkg;
    private AtomicInteger count = new AtomicInteger(0);
    private String appKey;
    private boolean mTimerStart = false;
    private static final String KEY_MAGIC = "HiidoYYSystem";

    public MetricsWorker(String string, IStatisHttpUtil iStatisHttpUtil, IStatisHttpUtil iStatisHttpUtil2) {
        this.mMetircs = iStatisHttpUtil;
        this.mHiido = iStatisHttpUtil2;
        this.appKey = string;
        this.pkg = new MetricsPkg(this.maxCount);
        this.mTimerStart = false;
    }

    private void changePkgMaxCount(boolean bl) {
        this.maxCount = bl ? (this.maxCount += 5) : (this.maxCount -= 5);
        if (this.maxCount > 100) {
            this.maxCount = 100;
        }
        if (this.maxCount < 5) {
            this.maxCount = 5;
        }
        Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Metrics next pkg piece count: %d. ", this.maxCount));
    }

    private void checkPkgWithTimer() {
        if (this.count.get() > 0 && !this.mTimerStart) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "post timer to report Metrics pkg count: %d", this.count.get()));
            this.mTimerStart = true;
            HMRContext.work.asyncAfter("MEtricsWorker::checkPkgWithTimer", 120000, new Runnable(){

                @Override
                public void run() {
                    MetricsWorker.this.onTimer();
                    MetricsWorker.this.mTimerStart = false;
                }
            });
        }
    }

    private void onTimer() {
        if (this.count.get() > 0) {
            try {
                Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Metrics onTimer piece count: %d. ", this.count.get()));
                MetricsPkg metricsPkg = this.pkg;
                this.pkg = new MetricsPkg(this.maxCount);
                this.count.set(0);
                this.sendPkg(metricsPkg);
            }
            catch (Throwable throwable) {
                Log.e(TAG, Trace.once().method("onTimer").info("error", throwable.getMessage()));
            }
        }
    }

    private void sendPkg(MetricsPkg metricsPkg) {
        try {
            List<JSONObject> list = metricsPkg.toJson();
            for (JSONObject jSONObject : list) {
                String string = this.toContent(jSONObject);
                if (string == null) continue;
                this.sendHttp(string);
            }
        }
        catch (Throwable throwable) {
            Log.e(TAG, Trace.once().method("sendPkg").info("error", throwable.getMessage()));
        }
    }

    private void sendHttp(String string) {
        try {
            string = String.format(Locale.US, "%s&hd_stime=%d", string, Util.wallTimeMillis());
            boolean bl = this.mMetircs.sendSync(string);
            this.changePkgMaxCount(bl);
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report Metrics %B to send command %s. ", bl, string));
        }
        catch (Throwable throwable) {
            Log.e(TAG, Trace.once().method("sendHttp").info("error", throwable.getMessage()));
        }
    }

    private String toContent(JSONObject jSONObject) {
        try {
            long l;
            StatisContent statisContent = new StatisContent();
            String string = String.valueOf(Util.wallTimeSec());
            statisContent.put("act", ACT);
            statisContent.put("time", string);
            statisContent.put("key", this.calKey(ACT, string));
            statisContent.put("appkey", this.appKey);
            try {
                l = jSONObject.getLong("clienttime");
            }
            catch (Throwable throwable) {
                l = System.currentTimeMillis();
            }
            statisContent.put("clienttime", String.valueOf(l / 1000L));
            JSONArray jSONArray = null;
            if (jSONObject.has("reqdata")) {
                jSONArray = jSONObject.getJSONArray("reqdata");
            }
            JSONArray jSONArray2 = null;
            if (jSONObject.has("counterdata")) {
                jSONArray2 = jSONObject.getJSONArray("counterdata");
            }
            if (jSONArray != null) {
                statisContent.put("reqdata", this.notNull(jSONArray.toString()));
            }
            if (jSONArray2 != null) {
                statisContent.put("counterdata", this.notNull(jSONArray2.toString()));
            }
            return statisContent.toString();
        }
        catch (Throwable throwable) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", throwable.getLocalizedMessage()));
            return null;
        }
    }

    private String notNull(String string) {
        return string == null ? "" : string;
    }

    private String calKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(string2);
        stringBuilder.append(KEY_MAGIC);
        String string3 = stringBuilder.toString();
        stringBuilder.setLength(0);
        try {
            return Util.encryptMD5(string3).toLowerCase(Locale.getDefault());
        }
        catch (Throwable throwable) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", throwable.getLocalizedMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsPkg cutPiece() {
        MetricsPkg metricsPkg = null;
        MetricsWorker metricsWorker = this;
        synchronized (metricsWorker) {
            int n = this.count.get();
            if (n > this.maxCount) {
                metricsPkg = this.pkg;
                this.pkg = new MetricsPkg(this.maxCount);
                this.count.set(0);
            }
        }
        return metricsPkg;
    }

    public void reportReturnCode(int n, String string, long l, String string2) {
        MetricsPkg metricsPkg;
        MetricsResult metricsResult = new MetricsResult(n, string, l, string2);
        this.pkg.addMetricsResult(metricsResult);
        int n2 = this.count.incrementAndGet();
        if (n2 > this.maxCount && (metricsPkg = this.cutPiece()) != null) {
            this.sendPkg(metricsPkg);
        }
        this.checkPkgWithTimer();
    }

    public void reportCount(int n, String string, String string2, long l) {
        this.reportCount(n, string, string2, l, 1);
    }

    public void reportCount(int n, String string, String string2, long l, int n2) {
        MetricsPkg metricsPkg;
        int n3;
        MetricsCount metricsCount = new MetricsCount(n, string, string2);
        metricsCount.count(l, n2);
        if (this.pkg.addCounter(metricsCount) && (n3 = this.count.incrementAndGet()) > this.maxCount && (metricsPkg = this.cutPiece()) != null) {
            this.sendPkg(metricsPkg);
        }
        this.checkPkgWithTimer();
    }

    public void reportReturnCodeTemporary(int n, String string, long l, String string2) {
        Log.i(HiidoReporter.TAG, String.format(Locale.US, "report return code uri: %s, code: %s", string, string2));
        MetricsPkg metricsPkg = new MetricsPkg(0);
        MetricsResult metricsResult = new MetricsResult(n, string, l, string2);
        metricsPkg.addMetricsResult(metricsResult);
        this.sendPkg(metricsPkg);
    }

    public void reportHiidoTemporary(String string, Map<String, Integer> map, Map<String, Long> map2, Map<String, String> map3) {
        StatisContent statisContent = new StatisContent();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            statisContent.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Number> entry : map2.entrySet()) {
            statisContent.put(entry.getKey(), (Long)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : map3.entrySet()) {
            statisContent.put(entry.getKey(), (String)entry.getValue());
        }
        statisContent.put("appkey", this.appKey);
        String string2 = String.valueOf(Util.wallTimeSec());
        statisContent.put("act", string);
        statisContent.put("time", string2);
        statisContent.put("key", this.calKey(string, string2));
        this.mHiido.sendSync(statisContent.getContent());
    }
}

