/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import java.util.UUID;

public final class LogId {
    private long mBeginTime = System.currentTimeMillis() / 1000L;
    private long mDeviceHashID = 0L;
    private long mCurrLoopCnt = 0L;
    private static final long MAX_10BIT_NUM = 1024L;
    private static final long MAX_18BIT_NUM = 262144L;
    private static final LogId instance = new LogId();

    public static long generate() {
        return instance.makeId();
    }

    private LogId() {
        try {
            String string = UUID.randomUUID().toString();
            byte[] byArray = string.getBytes();
            this.mDeviceHashID = this.genHashNum(byArray);
        }
        catch (Throwable throwable) {
            Log.e("LogId", Trace.once("Failed constructing IDGenerator").info("exception", throwable.getMessage()));
        }
    }

    private long makeId() {
        if (this.mCurrLoopCnt >= 1023L) {
            this.mBeginTime = System.currentTimeMillis() / 1000L;
            this.mCurrLoopCnt = 0L;
        }
        long l = this.mBeginTime << 32 & 0x7FFFFFFF00000000L;
        long l2 = 1L;
        l |= l2 << 28 & 0xFFFFFFFFF0000000L;
        l |= this.mDeviceHashID << 10 & 0xFFFFC00L;
        ++this.mCurrLoopCnt;
        return l |= this.mCurrLoopCnt & 0x3FFL;
    }

    private long genHashNum(byte[] byArray) {
        if (byArray == null || byArray[0] == 0) {
            return 0L;
        }
        long l = 5381L;
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            l *= 33L;
            l ^= (long)byArray[n];
            if (0 != ++n) continue;
        }
        return l %= 262144L;
    }

    private final class Terminal {
        static final int ANDROID = 1;

        private Terminal() {
        }
    }
}

