/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import java.util.concurrent.Semaphore;

public final class DispatchQueue {
    public static final DispatchQueue main = new DispatchQueue(new LooperHandlerProvider(Looper.getMainLooper()));
    public static final DispatchQueue direct = new DispatchQueue(new WorkerHandler("hmr_callBack"));
    private static final String TAG = "DispatchQueue";
    private final Handler handler;

    public void async(final @NonNull String string, final @NonNull Runnable runnable) {
        HMRContext.recorder.start("[async]" + string);
        if (this.handler == null) {
            Log.i(TAG, Trace.once().method("async").msg("runnable, run"));
            runnable.run();
            HMRContext.recorder.stop("[async]" + string);
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                HMRContext.recorder.stop("[async]" + string);
            }
        });
    }

    public void sync(final @NonNull String string, final @NonNull Runnable runnable) {
        boolean bl;
        HMRContext.recorder.start("[sync]" + string);
        if (this.handler == null) {
            runnable.run();
            HMRContext.recorder.stop("[sync]" + string);
            return;
        }
        boolean bl2 = bl = Looper.myLooper() == this.handler.getLooper();
        if (bl) {
            runnable.run();
            HMRContext.recorder.stop("[sync]" + string);
        } else {
            final Semaphore semaphore = new Semaphore(0);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    HMRContext.recorder.stop("[sync]" + string);
                    semaphore.release();
                }
            });
            semaphore.acquireUninterruptibly(1);
        }
    }

    public void asyncAfter(@NonNull String string, int n, @NonNull Runnable runnable) {
        HMRContext.recorder.start("[asyncAfter]" + string);
        if (this.handler == null) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            runnable.run();
            HMRContext.recorder.stop("[asyncAfter]" + string);
        } else {
            this.handler.postDelayed(runnable, (long)n);
            HMRContext.recorder.stop("[asyncAfter]" + string);
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public DispatchQueue() {
        this.handler = null;
    }

    public DispatchQueue(HandlerProvider handlerProvider) {
        this.handler = handlerProvider.getHandler();
    }

    public static class WorkerHandler
    implements HandlerProvider {
        private final String threadName;

        public WorkerHandler(String string) {
            this.threadName = string;
        }

        @Override
        public Handler getHandler() {
            HandlerThread handlerThread = new HandlerThread(this.threadName);
            handlerThread.start();
            return new Handler(handlerThread.getLooper());
        }
    }

    public static class LooperHandlerProvider
    implements HandlerProvider {
        private final Handler handler;

        public LooperHandlerProvider(@NonNull Looper looper) {
            this.handler = new Handler(looper);
        }

        @Override
        public Handler getHandler() {
            return this.handler;
        }
    }

    public static interface HandlerProvider {
        public Handler getHandler();
    }
}

