/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.services.upload.YYaliOSS;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.callback.OSSRetryCallback;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.upload.Uploader;
import com.hummer.im._internals.services.upload.YYaliOSS.OSSCredentialProviderImpl;
import com.hummer.im._internals.shared.FileUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class AliOSS
implements Uploader {
    private static final String TAG = "AliOSS";
    private static final String DEFAULT_OSS_REGION = "cn-shenzhen";
    private static final Map<String, String> REGION_BUCKET_MAP = new HashMap<String, String>();

    @Override
    public void uploadFile(final @NonNull String string, final @NonNull Uploader.UploadCallback<String> uploadCallback) {
        HMRContext.work.async("AliOSS::uploadFile", new Runnable(){

            @Override
            public void run() {
                if (!FileUtils.exists(string)) {
                    uploadCallback.onFailure(new Error(1003, "File not existed!"));
                    return;
                }
                AliOSS.startUploading(string, new Uploader.UploadCallback<String>(){

                    @Override
                    public void onProgress(float f) {
                        uploadCallback.onProgress(f);
                    }

                    @Override
                    public void onSuccess(String string) {
                        uploadCallback.onSuccess(string);
                    }

                    @Override
                    public void onFailure(Error error) {
                        uploadCallback.onFailure(error);
                    }
                });
            }
        });
    }

    @Override
    public void cancelUploadFile(@NonNull String string) {
    }

    @Override
    @Nullable
    public String acquireThumbImageUrl(String string, int n, int n2) {
        if (string.matches("^https?://cim-oss.*/\\d+/[^?]*$")) {
            return String.format(Locale.US, "%s?x-oss-process=image/resize,m_lfit,h_%d,w_%d", string, n2, n);
        }
        return null;
    }

    private static void startUploading(final @NonNull String string, final @NonNull Uploader.UploadCallback<String> uploadCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                String string10 = (String)REGION_BUCKET_MAP.get(HMRContext.region.area);
                if (TextUtils.isEmpty((CharSequence)string10)) {
                    Log.e(AliOSS.TAG, Trace.once().method("startUploading").info("region.area", HMRContext.region.area));
                    string10 = AliOSS.DEFAULT_OSS_REGION;
                }
                String string2 = "";
                int n = string.lastIndexOf(".");
                if (n > 0) {
                    string2 = string.substring(n);
                }
                String string3 = UUID.randomUUID().toString();
                String string4 = String.valueOf(HMR.getMe().getId());
                String string5 = string4 + "/" + string3 + string2;
                String string6 = "https://oss-" + string10 + ".aliyuncs.com";
                String string7 = "cim-" + string10;
                String string8 = string7 + "-" + HMRContext.appId;
                final OSSCredentialProviderImpl oSSCredentialProviderImpl = new OSSCredentialProviderImpl(string10);
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setMaxErrorRetry(3);
                OSSClient oSSClient = new OSSClient(HMRContext.getAppContext(), string6, (OSSCredentialProvider)oSSCredentialProviderImpl, clientConfiguration);
                final float[] fArray = new float[]{0.0f};
                PutObjectRequest putObjectRequest = new PutObjectRequest(string8, string5, string);
                putObjectRequest.setProgressCallback((OSSProgressCallback)new OSSProgressCallback<PutObjectRequest>(){

                    public void onProgress(PutObjectRequest putObjectRequest, long l, long l2) {
                        float f;
                        float f2 = f = l2 == 0L ? 0.0f : (float)l / (float)l2;
                        if (f - fArray[0] >= 0.01f) {
                            fArray[0] = (float)((int)(f * 100.0f)) / 100.0f;
                            HMRContext.work.async("AliOSS::progressCallback", new Runnable(){

                                @Override
                                public void run() {
                                    uploadCallback.onProgress(fArray[0]);
                                }
                            });
                        }
                    }
                });
                putObjectRequest.setRetryCallback(new OSSRetryCallback(){

                    public void onRetryCallback() {
                        oSSCredentialProviderImpl.setRetrying(true);
                    }
                });
                try {
                    oSSClient.putObject(putObjectRequest);
                    oSSCredentialProviderImpl.setRetrying(false);
                    final String string9 = "https://cim-oss-" + string10 + "-" + HMRContext.appId + ".bs2dl.yy.com/" + string5;
                    final long l2 = System.currentTimeMillis() - l;
                    HMRContext.work.async("AliOSS::startUploading", new Runnable(){

                        @Override
                        public void run() {
                            Log.i(AliOSS.TAG, Trace.once().method("startUploading").msg("Success").info("duration", "" + l2 + "ms"));
                            uploadCallback.onSuccess(string9);
                        }
                    });
                }
                catch (ClientException clientException) {
                    Log.e(AliOSS.TAG, Trace.once().method("startUploading").msg("Failed").info("localPath", string).info("remotePath", string5).info("exception", clientException.getMessage()));
                    HMRContext.work.async("AliOSS::ClientException", new Runnable(){

                        @Override
                        public void run() {
                            uploadCallback.onFailure(new Error(1010, "Upload failed"));
                        }
                    });
                }
                catch (ServiceException serviceException) {
                    Log.e(AliOSS.TAG, Trace.once().method("startUploading").msg("Failed").info("localPath", string).info("remotePath", string5).info("requestId", serviceException.getRequestId()).info("host", serviceException.getHostId()).info("msg", serviceException.getRawMessage()));
                    HMRContext.work.async("AliOSS::ServiceException", new Runnable(){

                        @Override
                        public void run() {
                            uploadCallback.onFailure(new Error(1010, "Upload failed"));
                        }
                    });
                }
            }
        }, "hmr_upload").start();
    }

    static {
        REGION_BUCKET_MAP.put("china", DEFAULT_OSS_REGION);
        REGION_BUCKET_MAP.put("shenzhen", DEFAULT_OSS_REGION);
        REGION_BUCKET_MAP.put("indonesia", "ap-southeast-5");
        REGION_BUCKET_MAP.put("america", "us_east-1");
        REGION_BUCKET_MAP.put("brazil", "us-east-1");
        REGION_BUCKET_MAP.put("india", "ap-south-1");
        REGION_BUCKET_MAP.put("Dubai", "me-east-1");
        REGION_BUCKET_MAP.put("KL", "ap-southeast-3");
    }
}

