/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im._internals.services.mq.RPCPullingResponse;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

public class RPCPullSharedMessages
extends IMRPC<Pull.PullGroupSysMsgRequest, Pull.PullGroupSysMsgRequest.Builder, Pull.PullGroupSysMsgResponse> {
    public static final String TAG = "RPCPullSharedMessages";
    private final Trace.Flow flow = new Trace.Flow();
    private final long groupId;
    private final String topic;
    private final boolean isInitialDrain;
    private final long seqId;
    private final int count;
    private final RichCompletionArg<RPCPullingResponse> completion;

    public RPCPullSharedMessages(long l, String string, long l2, int n, boolean bl, RichCompletionArg<RPCPullingResponse> richCompletionArg) {
        this.isInitialDrain = bl;
        this.groupId = l;
        this.topic = string;
        this.seqId = l2;
        this.count = n;
        this.completion = richCompletionArg;
    }

    @Override
    public long getLogId() {
        return this.flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "PullGroupSysMsg";
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.PullGroupSysMsgRequest.Builder builder) {
        ((Pull.PullGroupSysMsgRequest)builder.setGroupId(this.groupId).addAllUserTags(HMR.getTags()).setTopic(this.topic).setExclusiveStartSeqId(this.seqId).setLimit(this.count).setStatisDeliveryDelay(!this.isInitialDrain).build()).toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.PullGroupSysMsgResponse pullGroupSysMsgResponse) {
        Long l = pullGroupSysMsgResponse.getMaxSeqId() > 0L ? Long.valueOf(pullGroupSysMsgResponse.getMaxSeqId()) : null;
        CompletionUtils.dispatchSuccess(this.completion, new RPCPullingResponse(pullGroupSysMsgResponse.getMsgsList(), pullGroupSysMsgResponse.getHasMore(), l));
    }

    @Override
    public void handleHummerError(@Nullable Pull.PullGroupSysMsgResponse pullGroupSysMsgResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.PullGroupSysMsgResponse pullGroupSysMsgResponse) {
        return new StringChain().acceptNullElements().add("code", pullGroupSysMsgResponse.getCode()).add("desc", pullGroupSysMsgResponse.getMsg()).toString();
    }
}

