/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im._internals.services.mq.RPCPullingResponse;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

public class RPCPullPrivateMessages
extends IMRPC<Pull.PullMsgRequest, Pull.PullMsgRequest.Builder, Pull.PullMsgResponse> {
    public static final String TAG = "RPCPullPrivateMessages";
    private final boolean isFirstDrain;
    private final int count;
    private final long fromSeqId;
    private final String topic;
    private final RichCompletionArg<RPCPullingResponse> completion;
    private Trace.Flow flow;

    public RPCPullPrivateMessages(String string, boolean bl, long l, int n, Trace.Flow flow, RichCompletionArg<RPCPullingResponse> richCompletionArg) {
        this.topic = string;
        this.count = n;
        this.fromSeqId = l;
        this.completion = richCompletionArg;
        this.isFirstDrain = bl;
        this.flow = flow != null ? flow : new Trace.Flow();
    }

    @Override
    public long getLogId() {
        return this.flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "PullMsg";
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.PullMsgRequest.Builder builder) {
        ((Pull.PullMsgRequest)builder.setExclusiveStartSeqId(this.fromSeqId).setLimit(this.count).setTopic(this.topic).setStatisDeliveryDelay(!this.isFirstDrain).build()).toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.PullMsgResponse pullMsgResponse) {
        Long l = pullMsgResponse.getMaxSeqId();
        if (l == 0L) {
            l = null;
        }
        CompletionUtils.dispatchSuccess(this.completion, new RPCPullingResponse(pullMsgResponse.getMsgsList(), pullMsgResponse.getHasMore(), l));
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.PullMsgResponse pullMsgResponse) {
        return new StringChain().acceptNullElements().add("size", pullMsgResponse.getMsgsCount()).add("hasMore", pullMsgResponse.getHasMore()).add("maxSeqId", pullMsgResponse.getMaxSeqId()).toString();
    }

    @Override
    public void handleHummerError(@Nullable Pull.PullMsgResponse pullMsgResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }
}

