/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.log;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.services.mq.Statistics;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public final class Log {
    private static Logger logger;

    public static void d(String string, Object object) {
        Log.write(3, string, object.toString());
    }

    public static void i(String string, Object object) {
        Log.write(4, string, object.toString());
    }

    public static void w(String string, Object object) {
        Log.write(5, string, object.toString());
    }

    public static void e(String string, Object object) {
        Log.write(6, string, object.toString());
    }

    public static void e(final String string, final @NonNull Error error, final Object object) {
        Log.write(6, string, object.toString() + " >> " + error.toString());
        Statistics.report(new Statistics.Fields(error.code){
            {
                super(n);
                this.setErrInfo("[" + string + "] " + object.toString() + " >> " + error.desc);
            }
        });
    }

    public static void setLogger(@NonNull Logger logger) {
        Log.logger = logger;
    }

    public static Logger getLogger() {
        return logger;
    }

    private static void write(int n, String string, String string2) {
        if (logger != null) {
            logger.log(n, Log.stringFrom(string, string2));
        } else {
            android.util.Log.println((int)n, (String)"", (String)Log.stringFrom(string, string2));
        }
    }

    private static String stringFrom(String string, String string2) {
        Thread thread = Thread.currentThread();
        String string3 = thread.getName();
        if (string == null) {
            return String.format(Locale.US, "(%-12s)%s", string3, string2);
        }
        return String.format(Locale.US, "(%-12s)[%s] %s", string3, string, string2);
    }

    public static interface Logger {
        public void log(int var1, String var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Level {
        }
    }
}

