/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.chatsvc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.hummer.im.Error;
import com.hummer.im._internals.HummerException;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Chat;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.User;

public class RPCSendMessage
extends IMRPC<Chat.P2PChatRequest, Chat.P2PChatRequest.Builder, Chat.P2PChatResponse> {
    private final Message message;
    private final RichCompletion completion;

    public RPCSendMessage(Message message, RichCompletion richCompletion) {
        this.message = message;
        this.completion = richCompletion;
    }

    @Override
    public String getHummerFunction() {
        if (this.message.getReceiver() instanceof User) {
            return "P2PChat";
        }
        if (this.message.getReceiver() instanceof Group) {
            return "GroupChat";
        }
        Log.e("RPCSendMessage", Trace.once().method("performStarting").info("\u4e0d\u652f\u6301\u7684\u6d88\u606fReceiver\u7c7b\u578b: ", this.message.getReceiver()));
        return null;
    }

    @Override
    public void buildHummerRequest(@NonNull Chat.P2PChatRequest.Builder builder) {
        Object object;
        if (this.message.getPushContent() != null) {
            object = (Im.OsPushMsg)Im.OsPushMsg.newBuilder().setTitle(this.message.getPushContent().getTitle()).setContent(this.message.getPushContent().getContent()).setPayload(ByteString.copyFrom((byte[])this.message.getPushContent().getPayload())).setIcon(this.message.getPushContent().getIconUrl()).build();
            builder.setOsPushMsg((Im.OsPushMsg)object);
        }
        if ((object = this.message.getAppExtra()) == null) {
            object = "";
        }
        builder.setFromUid(this.message.getSender().getId()).setToUid(this.message.getReceiver().getId()).setUuid(this.message.getUuid()).setExtension((String)object);
        byte[] byArray = Content.makeBytes(this.message.getContent());
        Integer n = Content.getDataType(this.message.getContent());
        if (byArray == null || n == null) {
            throw new HummerException(1000, "Encode failed");
        }
        builder.setMsgType(n).setContent(ByteString.copyFrom((byte[])byArray));
    }

    @Override
    public String describeHummerRequest(Chat.P2PChatRequest p2PChatRequest) {
        return new StringChain().acceptNullElements().add("message", this.message).toString();
    }

    @Override
    public void handleHummerSuccess(@NonNull Chat.P2PChatResponse p2PChatResponse) {
        CompletionUtils.dispatchSuccess(this.completion);
    }

    @Override
    public void handleHummerError(@Nullable Chat.P2PChatResponse p2PChatResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull Chat.P2PChatResponse p2PChatResponse) {
        return null;
    }
}

