/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.chatsvc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.hummer.im.Error;
import com.hummer.im._internals.HummerException;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.chatsvc.IdentifiableHelper;
import com.hummer.im._internals.proto.Chat;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

public class RPCSendAppSessionMessage
extends IMRPC<Chat.AppSessionChatRequest, Chat.AppSessionChatRequest.Builder, Chat.AppSessionChatResponse> {
    private final Message message;
    private final RichCompletion completion;

    public RPCSendAppSessionMessage(Message message, RichCompletion richCompletion) {
        this.message = message;
        this.completion = richCompletion;
    }

    @Override
    public void buildHummerRequest(@NonNull Chat.AppSessionChatRequest.Builder builder) {
        String string = this.message.getAppExtra();
        if (string == null) {
            string = "";
        }
        builder.setFromUid(this.message.getSender().getId()).setToId(this.message.getReceiver().getId()).setToIdType(IdentifiableHelper.makeStringFrom(this.message.getReceiver())).setUuid(this.message.getUuid()).setExtension(string);
        byte[] byArray = Content.makeBytes(this.message.getContent());
        Integer n = Content.getDataType(this.message.getContent());
        if (byArray == null || n == null) {
            throw new HummerException(1000, "Encode failed");
        }
        builder.setMsgType(n).setContent(ByteString.copyFrom((byte[])byArray));
    }

    @Override
    public void handleHummerSuccess(@NonNull Chat.AppSessionChatResponse appSessionChatResponse) {
        CompletionUtils.dispatchSuccess(this.completion);
    }

    @Override
    public void handleHummerError(@Nullable Chat.AppSessionChatResponse appSessionChatResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }

    @Override
    public String getHummerFunction() {
        return "AppSessionChat";
    }

    @Override
    public String describeHummerRequest(Chat.AppSessionChatRequest appSessionChatRequest) {
        return new StringChain().acceptNullElements().add("message", this.message).toString();
    }

    @Override
    public String describeHummerResponse(@NonNull Chat.AppSessionChatResponse appSessionChatResponse) {
        return null;
    }
}

