/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.chatsvc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.History;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;

public class RPCFetchMessageSize
extends IMRPC<History.ReverseCountChatHistoryRequest, History.ReverseCountChatHistoryRequest.Builder, History.ReverseCountChatHistoryResponse> {
    private final Identifiable target;
    private final Long startTimestamp;
    private final Long endTimestamp;
    private final RichCompletionArg<Long> completion;

    RPCFetchMessageSize(@NonNull Identifiable identifiable, @NonNull Long l, @NonNull Long l2, @Nullable RichCompletionArg<Long> richCompletionArg) {
        this.target = identifiable;
        this.startTimestamp = l;
        this.endTimestamp = l2;
        this.completion = richCompletionArg;
    }

    @Override
    public void buildHummerRequest(@NonNull History.ReverseCountChatHistoryRequest.Builder builder) {
        ((History.ReverseCountChatHistoryRequest)builder.setToIdType(this.makeStringFrom(this.target)).setToId(this.target.getId()).setBeginTimestamp(this.startTimestamp).setEndTimestamp(this.endTimestamp).build()).toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull History.ReverseCountChatHistoryResponse reverseCountChatHistoryResponse) {
        CompletionUtils.dispatchSuccess(this.completion, Long.valueOf(reverseCountChatHistoryResponse.getCount()));
    }

    @Override
    public void handleHummerError(@Nullable History.ReverseCountChatHistoryResponse reverseCountChatHistoryResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull History.ReverseCountChatHistoryResponse reverseCountChatHistoryResponse) {
        return new StringChain().acceptNullElements().add("code", reverseCountChatHistoryResponse.getCode()).add("msg", reverseCountChatHistoryResponse.getMsg()).toString();
    }

    @Override
    public String getHummerFunction() {
        return "ReverseCountChatHistory";
    }

    private String makeStringFrom(Identifiable identifiable) {
        if (identifiable instanceof User) {
            return "user";
        }
        if (identifiable instanceof Group) {
            return "group";
        }
        if (identifiable instanceof AppSession) {
            return "app/" + ((AppSession)identifiable).getType();
        }
        return null;
    }
}

