/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.chatsvc;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;

public class IdentifiableHelper {
    static Identifiable makeIdentifiable(String string, long l) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length <= 0) {
            return null;
        }
        String string2 = stringArray[0].toLowerCase();
        String string3 = stringArray.length >= 2 ? stringArray[1] : null;
        switch (string2) {
            case "user": {
                return new User(l);
            }
            case "group": {
                return new Group(l);
            }
            case "app": {
                if (string3 == null) {
                    Log.e("IdentifiableHelper", Trace.once().method("makeIdentifiable").msg("AppSession").info("error", "[Format error]: format should be app/xxx"));
                    return null;
                }
                return new AppSession(string3, l);
            }
        }
        return null;
    }

    public static String makeStringFrom(Identifiable identifiable) {
        if (identifiable instanceof User) {
            return "user";
        }
        if (identifiable instanceof Group) {
            return "group";
        }
        if (identifiable instanceof AppSession) {
            return "app/" + ((AppSession)identifiable).getType();
        }
        return null;
    }
}

