/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.chatsvc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.chatsvc.RPCFetchMessageSize;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Delivering;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Init;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.Channel;
import com.hummer.im.service.ChatService;
import com.hummer.im.service.MQService;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class ChatServiceImpl
implements ServiceProvider.Service,
Channel.NotificationHandler,
ChatService,
MQService.MsgParser {
    public static final String TAG = "ChatService";
    private static final int MaxReceivedUUIDs = 100;
    private final Map<String, HashSet<ChatService.MessageListener>> mMessageListeners = new HashMap<String, HashSet<ChatService.MessageListener>>();
    private final Map<String, HashSet<ChatService.StateListener>> mStateListeners = new HashMap<String, HashSet<ChatService.StateListener>>();
    private static final String DEFAULT_STATE_LISTENER_KEY = "default_state_listener_key";
    private static final String DEFAULT_MESSAGE_LISTENER_KEY = "default_message_listener_key";
    private final Set<String> mUUIDsSent = new HashSet<String>();
    private final Deque<String> mUUIDsReceivedList = new LinkedList<String>();
    private final Set<String> mUUIDsReceivedSet = new HashSet<String>();
    private static List<SendingExtension> sendingExtensions = new ArrayList<SendingExtension>();
    private static List<ParserExtension> parserExtensions = new ArrayList<ParserExtension>();

    @Override
    public Class[] staticDependencies() {
        return new Class[]{MQService.class};
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[]{MQService.class};
    }

    @Override
    public void initService() {
        HMR.getService(MQService.class).registerMsgParser(this);
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        HMR.getService(Channel.class).addNotificationHandler(this);
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    @Override
    public void closeService() {
        HMR.getService(Channel.class).removeNotificationHandler(this);
    }

    @Override
    public void loadManually() {
        HMRContext.work.async("ChatService::loadManually", new Runnable(){

            @Override
            public void run() {
                HMR.getService(MQService.class).pullManually();
            }
        });
    }

    @Override
    public void send(final @NonNull Message message, final @Nullable HMR.Completion completion) {
        HMRContext.work.async("ChatService::send", new SendingFlow(){
            final Trace.Flow flow = new Trace.Flow();
            final RichCompletion rCompletion = new RichCompletion(completion, "ChatService::send");

            @Override
            public void run() {
                Error error = null;
                if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
                    error = new Error(1011, "User not login, or using anonymous mode");
                }
                if (message.getReceiver() == null) {
                    error = new Error(1002, "Bad message, no receiver found");
                }
                if (message.getState() != null && !(message.getState() instanceof Failed)) {
                    error = new Error(1002, "Bad message, unexpected state: " + message.getState());
                }
                if (message.getState() != null && (message.getSender() == null || message.getUuid() == null)) {
                    error = new Error(1002, "Bad message: " + message.toString());
                }
                if (message.getContent() == null) {
                    error = new Error(1002, "Bad message: Null content");
                }
                if (error != null) {
                    this.finish(error);
                    return;
                }
                this.supplementPropertiesIfNeeded();
                this.start();
            }

            private void supplementPropertiesIfNeeded() {
                if (message.getState() != null) {
                    return;
                }
                message.setSender(HMR.getMe());
                message.setTimestamp(System.currentTimeMillis());
                message.setUuid(UUID.randomUUID().toString());
                message.setState(new Init());
            }

            private void start() {
                Log.i(ChatServiceImpl.TAG, Trace.once().method("send").msg("start").info("msg", message));
                ChatServiceImpl.this.notifyBeforeSendingMessage(message);
                this.setMessageState(new Preparing());
                if (message.getContent() instanceof Content.Preparable) {
                    ((Content.Preparable)((Object)message.getContent())).prepare(this);
                } else {
                    this.performSending();
                }
            }

            @Override
            public void onPrepare(Preparing.Progress progress) {
                this.setMessageState(new Preparing(progress));
            }

            @Override
            public void onPrepareSuccess() {
                Log.i(ChatServiceImpl.TAG, this.flow.trace().method("send").msg("onPrepareSuccess"));
                HMRContext.work.async("ChatService::onPrepareSuccess", new Runnable(){

                    @Override
                    public void run() {
                        this.performSending();
                    }
                });
            }

            @Override
            public void onPrepareFailed(Error error) {
                Log.i(ChatServiceImpl.TAG, this.flow.trace().method("send").msg("onPrepareFailed").info("error", error));
                this.setMessageState(new Failed(error));
                this.finish(error);
            }

            private void performSending() {
                Log.i(ChatServiceImpl.TAG, this.flow.trace().method("send").msg("performSending"));
                this.setMessageState(new Delivering());
                ChatServiceImpl.this.cacheMessageUUID(message.getUuid());
                RichCompletion richCompletion = new RichCompletion("ChatService::performSending").onSuccess(new OnSuccess(){

                    @Override
                    public void onSuccess() {
                        Log.i(ChatServiceImpl.TAG, flow.trace().method("send").msg("onSendingSucceed"));
                        this.setMessageState(new Archived());
                        this.finish(null);
                    }
                }).onFailure(new OnFailure(){

                    @Override
                    public void onFailure(Error error) {
                        Log.e(ChatServiceImpl.TAG, flow.trace().method("send").msg("onSendingFailed").info("error", error));
                        if (error.code != 1005) {
                            ChatServiceImpl.this.uncacheMessageUUID(message.getUuid());
                        }
                        this.setMessageState(new Failed(error));
                        this.finish(error);
                    }
                });
                Channel.RPC rPC = ChatServiceImpl.makeSendingRPC(message, richCompletion);
                if (rPC == null) {
                    Error error = new Error(1002, "\u8be5\u6d88\u606f\u672a\u88ab\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6\u662f\u5426\u6ce8\u518c");
                    ChatServiceImpl.this.uncacheMessageUUID(message.getUuid());
                    this.setMessageState(new Failed(error));
                    this.finish(error);
                } else {
                    HMR.getService(Channel.class).run(rPC);
                }
            }

            private void setMessageState(final Message.State state) {
                DispatchQueue.main.sync("CHatService::setMessageState", new Runnable(){

                    @Override
                    public void run() {
                        message.setState(state);
                        ChatServiceImpl.this.notifyMessageStateChange(message, state);
                    }
                });
            }

            private void finish(@Nullable Error error) {
                ChatServiceImpl.this.notifyAfterSendingMessage(message);
                if (error == null) {
                    Log.i(ChatServiceImpl.TAG, this.flow.trace().method("send").msg("finish"));
                    CompletionUtils.dispatchSuccess(this.rCompletion);
                } else {
                    Log.e(ChatServiceImpl.TAG, error, this.flow.trace().method("send").msg("finish"));
                    CompletionUtils.dispatchFailure(this.rCompletion, error);
                }
            }
        });
    }

    @Override
    public void forward(@NonNull Message message, @NonNull List<Identifiable> list) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            Log.e(TAG, Trace.once("forward").msg("User not login, or using anonymous mode"));
            return;
        }
        for (Identifiable identifiable : list) {
            Message message2 = new Message(identifiable, message.getContent());
            this.send(message2, null);
        }
    }

    public void countRambleMessages(@NonNull Identifiable identifiable, long l, long l2, @Nullable RichCompletionArg<Long> richCompletionArg) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            Log.e(TAG, Trace.once("forward").msg("User not login, or using anonymous mode"));
            return;
        }
        HMR.getService(Channel.class).run(new RPCFetchMessageSize(identifiable, l, l2, richCompletionArg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(@Nullable Identifiable identifiable, @NonNull ChatService.MessageListener messageListener) {
        Map<String, HashSet<ChatService.MessageListener>> map = this.mMessageListeners;
        synchronized (map) {
            HashSet<ChatService.MessageListener> hashSet;
            String string = DEFAULT_MESSAGE_LISTENER_KEY;
            if (identifiable != null) {
                string = String.valueOf(identifiable.getId());
            }
            if ((hashSet = this.mMessageListeners.get(string)) == null) {
                hashSet = new HashSet();
                this.mMessageListeners.put(string, hashSet);
            }
            hashSet.add(messageListener);
            Log.d(TAG, Trace.once().method("addMessageListener").info("name", messageListener.getClass().getSimpleName()).info("size", hashSet.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(@Nullable Identifiable identifiable, @NonNull ChatService.MessageListener messageListener) {
        Map<String, HashSet<ChatService.MessageListener>> map = this.mMessageListeners;
        synchronized (map) {
            HashSet<ChatService.MessageListener> hashSet;
            String string = DEFAULT_MESSAGE_LISTENER_KEY;
            if (identifiable != null) {
                string = String.valueOf(identifiable.getId());
            }
            if ((hashSet = this.mMessageListeners.get(string)) != null) {
                hashSet.remove(messageListener);
            }
            Log.d(TAG, Trace.once().method("removeMessageListener").info("name", messageListener.getClass().getSimpleName()).info("size", hashSet == null ? "<null>" : Integer.valueOf(hashSet.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(@Nullable Message message, @NonNull ChatService.StateListener stateListener) {
        Map<String, HashSet<ChatService.StateListener>> map = this.mStateListeners;
        synchronized (map) {
            HashSet<ChatService.StateListener> hashSet;
            String string = DEFAULT_STATE_LISTENER_KEY;
            if (message != null) {
                string = message.getUuid();
            }
            if ((hashSet = this.mStateListeners.get(string)) == null) {
                hashSet = new HashSet();
                this.mStateListeners.put(string, hashSet);
            }
            hashSet.add(stateListener);
            Log.d(TAG, Trace.once().method("addStateListener").info("name", stateListener.getClass().getSimpleName()).info("size", hashSet.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(@Nullable Message message, @NonNull ChatService.StateListener stateListener) {
        Map<String, HashSet<ChatService.StateListener>> map = this.mStateListeners;
        synchronized (map) {
            HashSet<ChatService.StateListener> hashSet;
            String string = DEFAULT_STATE_LISTENER_KEY;
            if (message != null) {
                string = message.getUuid();
            }
            if ((hashSet = this.mStateListeners.get(string)) != null) {
                hashSet.remove(stateListener);
            }
            Log.d(TAG, Trace.once().method("removeStateListener").info("name", stateListener.getClass().getSimpleName()).info("size", hashSet == null ? "<null>" : Integer.valueOf(hashSet.size())));
        }
    }

    private void cacheMessageUUID(String string) {
        this.mUUIDsSent.add(string);
    }

    private void uncacheMessageUUID(String string) {
        this.mUUIDsSent.remove(string);
    }

    private void cacheReceivedMessage(Message message) {
        String string;
        if (this.mUUIDsReceivedList.size() >= 100) {
            string = this.mUUIDsReceivedList.pop();
            this.mUUIDsReceivedSet.remove(string);
        }
        string = message.getUuid();
        this.mUUIDsReceivedList.push(string);
        this.mUUIDsReceivedSet.add(string);
    }

    private boolean alreadyReceived(Message message) {
        return this.mUUIDsReceivedSet.contains(message.getUuid());
    }

    private boolean conflateLocalSent(Message message) {
        if (this.mUUIDsSent.contains(message.getUuid())) {
            this.mUUIDsSent.remove(message.getUuid());
            return true;
        }
        return false;
    }

    private void iterateMessageListeners(final Message message, final MessageListenersVisitor messageListenersVisitor) {
        DispatchQueue.main.sync("ChatService::" + messageListenersVisitor.visitorName(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ChatServiceImpl.this.mMessageListeners;
                synchronized (map) {
                    String string = String.valueOf(message.getTarget() == null ? "" : Long.valueOf(message.getTarget().getId()));
                    HashSet hashSet = (HashSet)ChatServiceImpl.this.mMessageListeners.get(string);
                    HashSet hashSet2 = hashSet == null ? new HashSet() : (HashSet)hashSet.clone();
                    HashSet hashSet3 = (HashSet)ChatServiceImpl.this.mMessageListeners.get(ChatServiceImpl.DEFAULT_MESSAGE_LISTENER_KEY);
                    if (hashSet3 != null) {
                        hashSet2.addAll((HashSet)hashSet3.clone());
                    }
                    for (ChatService.MessageListener messageListener : hashSet2) {
                        messageListenersVisitor.visit(messageListener);
                    }
                }
            }
        });
    }

    private void notifyBeforeSendingMessage(final Message message) {
        this.iterateMessageListeners(message, new MessageListenersVisitor(){

            @Override
            public void visit(ChatService.MessageListener messageListener) {
                messageListener.beforeSendingMessage(message);
            }

            @Override
            public String visitorName() {
                return "notifyBeforeSendingMessage";
            }
        });
    }

    private void notifyAfterSendingMessage(final Message message) {
        this.iterateMessageListeners(message, new MessageListenersVisitor(){

            @Override
            public void visit(ChatService.MessageListener messageListener) {
                messageListener.afterSendingMessage(message);
            }

            @Override
            public String visitorName() {
                return "notifyAfterSendingMessage";
            }
        });
    }

    private void notifyBeforeReceiveMessage(final Message message) {
        this.iterateMessageListeners(message, new MessageListenersVisitor(){

            @Override
            public void visit(ChatService.MessageListener messageListener) {
                messageListener.beforeReceivingMessage(message);
            }

            @Override
            public String visitorName() {
                return "notifyBeforeReceiveMessage";
            }
        });
    }

    private void notifyAfterReceiveMessage(final Message message) {
        this.iterateMessageListeners(message, new MessageListenersVisitor(){

            @Override
            public void visit(ChatService.MessageListener messageListener) {
                messageListener.afterReceivingMessage(message);
            }

            @Override
            public String visitorName() {
                return "notifyAfterReceiveMessage";
            }
        });
    }

    private void notifyMessageStateChange(final Message message, final Message.State state) {
        DispatchQueue.main.sync("ChatService::notifyMessageStateChange", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ChatServiceImpl.this.mStateListeners;
                synchronized (map) {
                    HashSet hashSet;
                    HashSet hashSet2 = (HashSet)ChatServiceImpl.this.mStateListeners.get(message.getUuid());
                    if (hashSet2 != null) {
                        hashSet = (HashSet)hashSet2.clone();
                        for (Object object : hashSet) {
                            object.onUpdateMessageState(message, state);
                        }
                    }
                    if ((hashSet = (HashSet)ChatServiceImpl.this.mStateListeners.get(ChatServiceImpl.DEFAULT_STATE_LISTENER_KEY)) != null) {
                        Object object;
                        HashSet hashSet3 = (HashSet)hashSet.clone();
                        object = hashSet3.iterator();
                        while (object.hasNext()) {
                            ChatService.StateListener stateListener = (ChatService.StateListener)object.next();
                            stateListener.onUpdateMessageState(message, state);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void parse(Im.Msg msg, Source source) {
        this.dispatchMessage(ChatServiceImpl.makeMessage(msg, source));
    }

    @Override
    public void onNotify(String string, String string2, byte[] byArray) {
        this.dispatchMessage(ChatServiceImpl.makeMessage(string, string2, byArray));
    }

    private void dispatchMessage(final Message message) {
        if (message == null) {
            return;
        }
        HMRContext.work.async("ChatService::dispatchMessage", new Runnable(){

            @Override
            public void run() {
                if (ChatServiceImpl.this.conflateLocalSent(message)) {
                    return;
                }
                if (ChatServiceImpl.this.alreadyReceived(message)) {
                    Log.w(ChatServiceImpl.TAG, Trace.once().method("dispatchMessage").msg("\u91cd\u590d\u6d88\u606f").info("uuid", message.getUuid()));
                    return;
                }
                ChatServiceImpl.this.notifyBeforeReceiveMessage(message);
                ChatServiceImpl.this.notifyAfterReceiveMessage(message);
                ChatServiceImpl.this.cacheReceivedMessage(message);
            }
        });
    }

    public static void registerSendingExtension(SendingExtension sendingExtension) {
        sendingExtensions.add(sendingExtension);
    }

    public static void registerParserExtension(ParserExtension parserExtension) {
        parserExtensions.add(parserExtension);
    }

    private static Channel.RPC makeSendingRPC(Message message, RichCompletion richCompletion) {
        for (SendingExtension sendingExtension : sendingExtensions) {
            Channel.RPC rPC = sendingExtension.makeSendingRPC(message, richCompletion);
            if (rPC == null) continue;
            return rPC;
        }
        return null;
    }

    private static Message makeMessage(String string, String string2, byte[] byArray) {
        for (ParserExtension parserExtension : parserExtensions) {
            try {
                Message message = parserExtension.parseMessage(string, string2, byArray);
                if (message == null) continue;
                Log.d("Core", Trace.once().method("makeMessage1").info("parser", parserExtension).info("message", message));
                return message;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static Message makeMessage(Im.Msg msg, Source source) {
        for (ParserExtension parserExtension : parserExtensions) {
            try {
                Message message = parserExtension.parseMessage(msg, source);
                if (message == null) continue;
                Log.d("Core", Trace.once().method("makeMessage2").info("parser", parserExtension).info("message", message));
                return message;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static interface ParserExtension {
        public Message parseMessage(String var1, String var2, byte[] var3);

        public Message parseMessage(Im.Msg var1, Source var2);
    }

    public static interface SendingExtension {
        public Channel.RPC makeSendingRPC(Message var1, RichCompletion var2);
    }

    private static interface SendingFlow
    extends Content.PreparingCallback,
    Runnable {
    }

    static interface MessageListenersVisitor {
        public void visit(ChatService.MessageListener var1);

        public String visitorName();
    }
}

