/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;
import java.util.Locale;

public final class PrefStorage
implements ServiceProvider.Service {
    private static final String TAG = "PrefStorage";
    private static PrefStorage sharedStorage;
    private static int NumberOfClosing;
    private static int NumberOfOpening;
    private SharedPreferences preferences = null;
    private User me = null;

    private PrefStorage() {
    }

    public static PrefStorage storage() {
        if (sharedStorage == null) {
            sharedStorage = new PrefStorage();
        }
        return sharedStorage;
    }

    public <ResultType> ResultType execute(Query<ResultType> query) {
        if (!this.isValidContext()) {
            Log.w(TAG, Trace.once().method("execute").msg("Bad Context : %s ", this.serviceSnapshot()));
            return null;
        }
        return query.run(this.preferences);
    }

    public void execute(Edit edit) {
        if (!this.isValidContext()) {
            Log.w(TAG, Trace.once().method("execute").msg("Bad Context : %s ", this.serviceSnapshot()));
            return;
        }
        SharedPreferences.Editor editor = this.preferences.edit();
        edit.run(editor);
        editor.apply();
    }

    private boolean isValidContext() {
        return this.preferences != null && HMR.isMe(this.me);
    }

    private String serviceSnapshot() {
        return "me: " + HMR.getMe() + ", isRunning: " + (this.preferences != null) + ", opening: " + NumberOfOpening + ", closing: " + NumberOfClosing;
    }

    @Override
    public Class[] staticDependencies() {
        return null;
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public void initService() {
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        ++NumberOfOpening;
        if (this.me != null || this.preferences != null) {
            Log.w(TAG, Trace.once().method("open").msg("Nonsense opening: " + this.serviceSnapshot()));
            return;
        }
        this.me = HMR.getMe();
        if (this.me == null) {
            Log.e(TAG, Trace.once().method("openService").info("\u65e0\u6548\u7684Me\u5bf9\u8c61:" + HMR.getMe() + ", " + this.serviceSnapshot(), null));
            CompletionUtils.dispatchFailure(richCompletion, new Error(1011, "User not login."));
            return;
        }
        HMRContext.Region region = HMRContext.region;
        String string = String.format(Locale.US, "svc_%s_cim_%s_%s_proxy", region.area, region.type, region.name);
        String string2 = String.format(Locale.US, "im_%d_%d_%s", HMRContext.getAppId(), this.me.getId(), string);
        this.preferences = HMRContext.getAppContext().getSharedPreferences(string2, 0);
        Log.i(TAG, Trace.once().method("open").info("prefName", string2));
        if (this.preferences == null) {
            Log.e(TAG, Trace.once().method("openService").info("\u65e0\u6cd5\u521b\u5efaPreferences\u6587\u4ef6 | " + this.serviceSnapshot(), null));
        }
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    @Override
    public void closeService() {
        ++NumberOfClosing;
        Log.i(TAG, Trace.once().method("close"));
        if (!this.isValidContext()) {
            Log.w(TAG, Trace.once().method("close").msg("Nonsense closing: ", this.serviceSnapshot()));
            return;
        }
        this.preferences = null;
        this.me = null;
    }

    static {
        NumberOfClosing = 0;
        NumberOfOpening = 0;
    }

    public static interface Edit {
        public void run(SharedPreferences.Editor var1);
    }

    public static interface Query<ResultType> {
        public ResultType run(SharedPreferences var1);
    }
}

