/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.SparseIntArray;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.HummerException;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im.model.auth.TokenProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import com.yy.platform.baseservice.ConstCode;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.profile.ChannelProfile;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.profile.ServiceProfileFactory;
import com.yy.platform.baseservice.task.BindTask;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTaskV2;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.task.UnBindTask;
import com.yy.platform.baseservice.utils.UserGroupTypeString;
import com.yy.yylogger.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ServiceChannel
implements Channel {
    private static final String TAG = "ServiceChannel";
    private final IChannelListener.IServiceBroadcastNotify bcNotifyHandler = new IChannelListener.IServiceBroadcastNotify(){

        public void onBroadCast(long l, long l2, long l3, String string, String string2, String string3, byte[] byArray) {
            ServiceChannel.this.onNotify(string, string2, byArray);
        }
    };
    private final IChannelListener.IServiceUnicastNotify unicastNotifyHandler = new IChannelListener.IServiceUnicastNotify(){

        public void onUnicast(long l, String string, String string2, String string3, byte[] byArray) {
            ServiceChannel.this.onNotify(string, string2, byArray);
        }
    };
    private final IChannelListener.IServiceStrGroupBroadcastNotify strGroupBroadcastNotifyHandler = new IChannelListener.IServiceStrGroupBroadcastNotify(){

        public void onBroadCastFromStrGroup(long l, String string, String string2, String string3, String string4, byte[] byArray) {
            ServiceChannel.this.onNotify(string2, string3, byArray);
        }
    };
    private static Map<Channel.StateChangedListener, IChannelListener.IChannelStatusNotify> stateListeners = new HashMap<Channel.StateChangedListener, IChannelListener.IChannelStatusNotify>();
    private static List<Channel.NotificationHandler> notifyHandlers = new LinkedList<Channel.NotificationHandler>();
    private Mode mode;

    @Override
    public Class[] staticDependencies() {
        return null;
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return null;
    }

    @Override
    public void initService() {
        if (this.mode instanceof AutonomousMode) {
            Logger.createModule((String)"Service", (boolean)false);
            if (YYServiceCore.getInstance() == null) {
                YYServiceCore.initWithGSLB((Context)HMRContext.getAppContext(), (long)HMRContext.appId, (String)"", (ServiceProfileFactory)new ServiceProfileFactory(){

                    public LogProfile logProfile() {
                        return new LogProfile(){

                            public LogProfile.ILog getLog() {
                                return new LogProfile.ILog(){

                                    public void outputLog(String string) {
                                        Logger.i((String)"Service", (String)string);
                                    }
                                };
                            }

                            public String logPath() {
                                return null;
                            }

                            public boolean isLogCat() {
                                return false;
                            }
                        };
                    }

                    public ChannelProfile channelProfile() {
                        return null;
                    }
                }, null);
            }
        }
    }

    public ServiceChannel(Mode mode) {
        if (mode == null) {
            Log.e(TAG, Trace.once().method(TAG).info("mode", "null"));
        }
        this.mode = mode;
    }

    @Override
    public void openService(final @NonNull RichCompletion richCompletion) {
        YYServiceCore.getInstance().registUnicastListener(this.unicastNotifyHandler);
        YYServiceCore.getInstance().registBroadcastListener(this.bcNotifyHandler);
        YYServiceCore.getInstance().registBroadcastListener(this.strGroupBroadcastNotifyHandler);
        HMRContext.work.async("ServiceChannel::openService", new Runnable(){

            @Override
            public void run() {
                ServiceChannel.this.mode.performOpening(HMR.getMe(), new RichCompletion("").onSuccess(new OnSuccess(){

                    @Override
                    public void onSuccess() {
                        CompletionUtils.dispatchSuccess(richCompletion);
                    }
                }).onFailure(new OnFailure(){

                    @Override
                    public void onFailure(Error error) {
                        YYServiceCore.getInstance().unregistBroadcastListener(ServiceChannel.this.bcNotifyHandler);
                        YYServiceCore.getInstance().unregistUnicastListener(ServiceChannel.this.unicastNotifyHandler);
                        YYServiceCore.getInstance().unregistBroadcastListener(ServiceChannel.this.strGroupBroadcastNotifyHandler);
                        CompletionUtils.dispatchFailure(richCompletion, error);
                    }
                }));
            }
        });
    }

    @Override
    public void closeService() {
        YYServiceCore.getInstance().unregistBroadcastListener(this.bcNotifyHandler);
        YYServiceCore.getInstance().unregistUnicastListener(this.unicastNotifyHandler);
        YYServiceCore.getInstance().unregistBroadcastListener(this.strGroupBroadcastNotifyHandler);
        this.mode.performClosing();
    }

    @Override
    public void run(final Channel.RPC rPC) {
        Error error = null;
        final User user = HMR.getMe();
        if (user == null) {
            error = new Error(1002, "Missing login user!");
        }
        if (!this.isNetworkConnected()) {
            error = new Error(1004, "Network disconnected");
        }
        byte[] byArray = null;
        try {
            byArray = rPC.getRequestBytes();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (byArray == null) {
            error = new Error(1002, "Failed parsing data from request", rPC);
        }
        if (error != null) {
            Log.e(TAG, Trace.once().method("runRPC").msg(error.toString()));
            rPC.handleError(error);
            return;
        }
        RPCTask.RequestParam requestParam = new RPCTask.RequestParam("", rPC.serviceName(), rPC.getFunctionName(), byArray, rPC.protoType(), null, null, null);
        long l = System.currentTimeMillis();
        final String string = ServiceChannel.shortFunctionName(rPC);
        Log.i(TAG, Trace.once("start call rpc timestamp:%s, shortFunctionName:%s", l, string));
        YYServiceCore.getInstance().rpcCall(requestParam, null, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<RPCTask.ResponseParam>(){

            public void onSuccess(int n, final RPCTask.ResponseParam responseParam) {
                HMRContext.work.async("ServiceChannel::rpcSuccess:" + string, new Runnable(){

                    @Override
                    public void run() {
                        Error error = null;
                        try {
                            if (!HMR.isMe(user)) {
                                error = new Error(1000, "RPC overdue!", rPC);
                            } else {
                                rPC.handleResponse(responseParam.mResponseData);
                            }
                        }
                        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                            error = new Error(2000, "Protocol exceptions", (Object)invalidProtocolBufferException);
                        }
                        catch (HummerException hummerException) {
                            error = hummerException.error;
                        }
                        catch (Throwable throwable) {
                            error = new Error(-1, "Undefined exceptions", throwable);
                        }
                        if (error != null) {
                            rPC.handleError(error);
                            HiidoReporter.reportReturnCodeTemporary(string, 0L, error.code);
                        }
                    }
                });
            }

            public void onFail(int n, final int n2, final int n3, Exception exception) {
                HMRContext.work.async("ServiceChannel::rpcFail:" + string, new Runnable(){

                    @Override
                    public void run() {
                        if (!HMR.isMe(user)) {
                            Error error = new Error(1000, "RPC overdue!");
                            Log.w(ServiceChannel.TAG, error.desc);
                            rPC.handleError(error);
                            return;
                        }
                        Error error = n2 != 1 ? ServiceChannel.this.errorFromServiceFailure(true, n2) : ServiceChannel.this.errorFromServiceFailure(false, n3);
                        rPC.handleError(error);
                        HiidoReporter.reportReturnCodeTemporary(string, 0L, error.code);
                    }
                });
            }
        });
    }

    @Override
    public void addNotificationHandler(Channel.NotificationHandler notificationHandler) {
        notifyHandlers.add(notificationHandler);
    }

    @Override
    public void removeNotificationHandler(Channel.NotificationHandler notificationHandler) {
        notifyHandlers.remove(notificationHandler);
    }

    @Override
    public void subscribeGroupcast(String string, final RichCompletion richCompletion) {
        HashSet<UserGroupTypeString> hashSet = new HashSet<UserGroupTypeString>();
        hashSet.add(new UserGroupTypeString(string));
        YYServiceCore.getInstance().subscribeStrBroadcast(hashSet, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTaskV2.ResponseParam responseParam) {
                CompletionUtils.dispatchSuccess(richCompletion);
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                CompletionUtils.dispatchFailure(richCompletion, new Error(n2, exception.getLocalizedMessage()));
            }
        });
    }

    @Override
    public void unSubscribeGroupcast(String string, final RichCompletion richCompletion) {
        HashSet<UserGroupTypeString> hashSet = new HashSet<UserGroupTypeString>();
        hashSet.add(new UserGroupTypeString(string));
        YYServiceCore.getInstance().unSubscribeStrBroadcast(hashSet, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTaskV2.ResponseParam responseParam) {
                CompletionUtils.dispatchSuccess(richCompletion);
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                CompletionUtils.dispatchFailure(richCompletion, new Error(n2, exception.getLocalizedMessage()));
            }
        });
    }

    @Override
    public void addStateListener(final Channel.StateChangedListener stateChangedListener) {
        IChannelListener.IChannelStatusNotify iChannelStatusNotify = new IChannelListener.IChannelStatusNotify(){

            public void onStatus(int n) {
                if (n == 6) {
                    stateChangedListener.onChannelConnected();
                } else {
                    stateChangedListener.onChannelDisconnected();
                }
            }
        };
        stateListeners.put(stateChangedListener, iChannelStatusNotify);
        YYServiceCore.getInstance().registChannelStatusListener(iChannelStatusNotify, new Handler());
    }

    @Override
    public void removeStateListener(Channel.StateChangedListener stateChangedListener) {
        IChannelListener.IChannelStatusNotify iChannelStatusNotify = stateListeners.get(stateChangedListener);
        if (iChannelStatusNotify == null) {
            return;
        }
        YYServiceCore.getInstance().unregistChannelStatusListener(iChannelStatusNotify);
        stateListeners.remove(stateChangedListener);
    }

    private static String shortFunctionName(Channel.RPC rPC) {
        return rPC instanceof IMRPC ? ((IMRPC)rPC).getHummerFunction() : rPC.getFunctionName();
    }

    private void onNotify(final String string, final String string2, final byte[] byArray) {
        HMRContext.work.async("ServiceChannel::onNotify:" + string + "/" + string2, new Runnable(){

            @Override
            public void run() {
                for (Channel.NotificationHandler notificationHandler : notifyHandlers) {
                    notificationHandler.onNotify(string, string2, byArray);
                }
            }
        });
    }

    private boolean isNetworkConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)HMRContext.getAppContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isAvailable();
    }

    private Error errorFromServiceFailure(boolean bl, int n) {
        String string;
        if (bl) {
            SparseIntArray sparseIntArray = new SparseIntArray(){
                {
                    this.put(-1, 1007);
                    this.put(-2, 1009);
                    this.put(-3, 1005);
                }
            };
            string = ConstCode.SdkResCode.desc((int)n);
            n = sparseIntArray.get(n, 1003);
        } else {
            string = ConstCode.SrvResCode.desc((int)n);
            n = 4000;
        }
        return new Error(n, string);
    }

    public Mode getMode() {
        return this.mode;
    }

    public static final class AutonomousMode
    implements Mode {
        public static final int NEW_UDB_TOKEN = 0;
        public static final int THIRD_USER_TOKEN = 1;
        public static final int YY_UDB_TOKEN = 2;
        private TokenProvider tokenProvider;
        private final int tokenType;

        public AutonomousMode(int n) {
            this.tokenType = n;
        }

        public AutonomousMode(int n, TokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
            this.tokenType = n;
        }

        @Override
        public void performOpening(@NonNull User user, final @NonNull RichCompletion richCompletion) {
            if (user.isAnonymous()) {
                CompletionUtils.dispatchSuccess(richCompletion);
                return;
            }
            Log.i(ServiceChannel.TAG, Trace.once().method("performOpening").msg("bind service start"));
            YYServiceCore.getInstance().bind(user.getId(), this.tokenType, new IChannelListener.ITokenProvider(){

                public byte[] getToken(long l) {
                    return AutonomousMode.this.tokenProvider.getToken(l);
                }
            }, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BindTask.ResponseParam>(){

                public void onSuccess(int n, BindTask.ResponseParam responseParam) {
                    Log.i(ServiceChannel.TAG, Trace.once().method("performOpening").msg("bind service done"));
                    CompletionUtils.dispatchSuccess(richCompletion);
                }

                public void onFail(int n, int n2, int n3, Exception exception) {
                    Log.i(ServiceChannel.TAG, Trace.once().method("performOpening").msg("bind service fail"));
                    CompletionUtils.dispatchFailure(richCompletion, new Error(n2, exception.getLocalizedMessage()));
                }
            });
        }

        @Override
        public void performClosing() {
            if (HMR.getMe().isAnonymous()) {
                return;
            }
            Log.i(ServiceChannel.TAG, Trace.once().method("performClosing").msg("unbind service start"));
            YYServiceCore.getInstance().unBind((IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<UnBindTask.ResponseParam>(){

                public void onSuccess(int n, UnBindTask.ResponseParam responseParam) {
                    Log.i(ServiceChannel.TAG, Trace.once().method("performClosing").msg("unbind service done"));
                }

                public void onFail(int n, int n2, int n3, Exception exception) {
                    Log.i(ServiceChannel.TAG, Trace.once().method("performClosing").msg("unbind service fail"));
                }
            });
        }

        public TokenProvider getTokenProvider() {
            return this.tokenProvider;
        }

        public void setTokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
        }
    }

    public static final class DelegateMode
    implements Mode {
        @Override
        public void performOpening(@NonNull User user, @NonNull RichCompletion richCompletion) {
            CompletionUtils.dispatchSuccess(richCompletion);
        }

        @Override
        public void performClosing() {
        }
    }

    public static interface Mode {
        public void performOpening(@NonNull User var1, @NonNull RichCompletion var2);

        public void performClosing();
    }
}

