package com.hummer.im.service;

import com.hummer.im.HMR;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.chat.store.FetchingResult;
import com.hummer.im.model.id.Identifiable;

public interface RoamingService {

    /**
     * 获取持久化在服务器的漫游消息。目前消息是否会被持久化，是由服务器端进行配置的。请注意区分漫游消息和离线
     * 消息之间的区别。离线消息是以可靠传输为目的的概念，会在用户在线时主动推送给关系方。但是漫游消息必须由业务
     * 主动触发拉取。
     *
     * <p>
     * 在FetchingResult中有List<Message>, hasMore, nextTimestamp
     * hasMore 表示是否还有消息需要拉取。true: 需要再次拉取，即使messages.size=0; false: 无需再次拉取
     * nextTimestamp 如果hasMore=true, 表示下次拉取消息的起始时间戳
     * </p>
     *
     * @param target 会话目标
     * @param clauses 历史消息请求条件。可设置target、beforeTimestamp、limit、senders、messageTypes
     * @param completion 请求的异步回调对象
     */
    void fetchMessages(Identifiable target, FetchingClauses clauses, HMR.CompletionArg<FetchingResult> completion);
}
